/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

var validator_flag = true;

function checkAndAlert(form){
	if(!validator_flag){
		return true;
	}
	var id = form.getAttribute("action");
	id = id.replace("(.+)\\.[^\\.]+", "$1");
	
	var context = new ValidatorContext();
	context.collectable = new SimpleMessageCollector();
	context.id = id;
	context.inputMap = convertFormToListMap(form);
	var flag = validator_tree.interpret(context);
	if(!flag){
		var sb = "";
		for(var i in context.collectable.messageList){
			sb = sb + "\n" + context.collectable.messageList[i];
		}
		alert(sb);
	}
	return flag;
}

var validator_tree = 
new SerialValidator(new AndAndValidatorIterable(),[new IfNotValidator(new ValidNamesValidator(["sex","age","userId","address","comment","hobby","name"]),new MessageValidator("validator.acceptable")),new BranchByNameIfExistsValidator(new AndValidatorIterable(),{"userId":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new ParseValidator(new DecimalFormat()),new MessageValidator("validator.userId.parse"))),"name":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new MaxLengthValidator(40),new MessageValidator("validator.name.maxLength"))),"sex":new ValueLoopValidator(new AndValidatorIterable(),new SerialValidator(new AndAndValidatorIterable(),[new IfNotValidator(new ValidValuesValidator(["0","1"]),new MessageValidator("validator.sex.acceptable")),new IfNotValidator(new ParseValidator(new DecimalFormat()),new MessageValidator("validator.sex.parse"))])),"address":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new MaxLengthValidator(80),new MessageValidator("validator.address.maxLength"))),"age":new ValueLoopValidator(new AndValidatorIterable(),new SerialValidator(new AndAndValidatorIterable(),[new IfNotValidator(new ParseValidator(new DecimalFormat()),new MessageValidator("validator.age.parse")),new IfNotValidator(new MinValidator(0),new MessageValidator("validator.age.min")),new IfNotValidator(new MaxValidator(200),new MessageValidator("validator.age.max"))])),"hobby":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new ValidValuesValidator(["0","1","2","3"]),new MessageValidator("validator.hobby.acceptable"))),"comment":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new MaxLengthValidator(200),new MessageValidator("validator.comment.maxLength")))}),new IfValidator(new RegExpIdValidator("user_(deleteConfirm|updateInput)"),new BranchByNameValidator(new AndValidatorIterable(),{"userId":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new RequiredValidator(),new MessageValidator("validator.userId.required")))}),new TrueValidator()),new IfValidator(new RegExpIdValidator("user_(register|update)(Confirm|Result)"),new BranchByNameValidator(new AndValidatorIterable(),{"name":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new RequiredValidator(),new MessageValidator("validator.name.required"))),"sex":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new RequiredValidator(),new MessageValidator("validator.sex.required"))),"address":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new RequiredValidator(),new MessageValidator("validator.address.required"))),"age":new ValueLoopValidator(new AndValidatorIterable(),new IfNotValidator(new RequiredValidator(),new MessageValidator("validator.age.required")))}),new TrueValidator())])
;