/*
 * Decompiled with CFR 0.152.
 */
package woolpack.acquirable;

import woolpack.acquirable.Acquirable;

public class AcquirableChain
implements Acquirable {
    private Acquirable[] array;

    public AcquirableChain(Acquirable ... acquirables) {
        this.array = acquirables;
    }

    public boolean acquire() {
        int i = 0;
        try {
            while (i < this.array.length) {
                if (!this.array[i].acquire()) {
                    break;
                }
                ++i;
            }
        }
        finally {
            if (i < this.array.length) {
                this.release(i - 1);
            }
        }
        return i >= this.array.length;
    }

    private void release(int length) {
        int i = length;
        while (i >= 0) {
            this.array[i].release();
            --i;
        }
    }

    public void release() {
        this.release(this.array.length - 1);
    }

    public Acquirable[] getArray() {
        return this.array;
    }

    public void setArray(Acquirable[] array) {
        this.array = array;
    }
}

