/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import woolpack.action.ActionInvoker;
import woolpack.action.ActionResult;
import woolpack.config.ConfigUtils;
import woolpack.ee.EEContext;
import woolpack.ee.EEUtils;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.el.MapEL;
import woolpack.fn.Fn;
import woolpack.html.HtmlUtils;
import woolpack.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBuilder {
    public static final EL DEFAULT_FORWARD_COMPONENT_EL_EL = new ArrayPathEL(EEUtils.LOCAL_EL, (EL)new MapEL("woolpack.ee.FORWARD_COMPONENT"));
    public static final EL DEFAULT_RETURN_EL = new ArrayPathEL(EEUtils.LOCAL_EL, (EL)new MapEL("returnMessages"));
    private ActionInvoker actionDefs;
    private Iterable<String> attrNames;
    private EL forwardComponentELEL;
    private EL returnEL;

    public ActionBuilder(ActionInvoker actionDefs, Iterable<String> attrNames, EL forwardComponentELEL, EL returnEL) {
        this.actionDefs = actionDefs;
        this.attrNames = attrNames;
        this.forwardComponentELEL = forwardComponentELEL;
        this.returnEL = returnEL;
    }

    public ActionBuilder(ActionInvoker actionDefs, Iterable<String> attrNames) {
        this(actionDefs, attrNames, DEFAULT_FORWARD_COMPONENT_EL_EL, DEFAULT_RETURN_EL);
    }

    public Fn<EEContext, Void> getActionExpression() {
        return new Fn<EEContext, Void>(){

            @Override
            public Void exec(EEContext context) {
                ActionResult actionResult = ActionBuilder.this.actionDefs.invoke(context, context.getId(), context.getInput());
                context.setId(actionResult.getForwardDef().getId());
                ActionBuilder.this.forwardComponentELEL.setValue(context, actionResult.getForwardDef().getComponentEL());
                if (actionResult.getReturnedObject() instanceof Throwable) {
                    ActionBuilder.this.returnEL.setValue(context, Utils.toMessageList((Throwable)actionResult.getReturnedObject()));
                } else {
                    ActionBuilder.this.returnEL.setValue(context, actionResult.getReturnedObject());
                }
                return null;
            }
        };
    }

    public Fn<EEContext, Void> getAutoUpdateExpression() {
        return new Fn<EEContext, Void>(){

            @Override
            public Void exec(EEContext context) {
                GettingEL o = (GettingEL)ActionBuilder.this.forwardComponentELEL.getValue(context);
                if (o != null) {
                    HtmlUtils.updateAuto(ActionBuilder.this.attrNames, o, ConfigUtils.CONFIG_EL).exec(context);
                }
                return null;
            }
        };
    }

    public ActionInvoker getActionDefs() {
        return this.actionDefs;
    }

    public void setActionDefs(ActionInvoker actionDefs) {
        this.actionDefs = actionDefs;
    }

    public Iterable<String> getAttrNames() {
        return this.attrNames;
    }

    public void setAttrNames(Iterable<String> attrNames) {
        this.attrNames = attrNames;
    }

    public EL getForwardComponentELEL() {
        return this.forwardComponentELEL;
    }

    public void setForwardComponentELEL(EL forwardComponentELEL) {
        this.forwardComponentELEL = forwardComponentELEL;
    }

    public EL getReturnEL() {
        return this.returnEL;
    }

    public void setReturnEL(EL returnEL) {
        this.returnEL = returnEL;
    }
}

