/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.ee;

import woolpack.el.AbstractGettingEL;
import woolpack.el.GettingEL;

/**
 * ユーティリティです。
 * 
 * @author nakamura
 * 
 */
public final class EEUtils {

	/**
	 * {@link EEContext}を基点とみなして
	 * {@link EEContext#getContainer()}を返す{@link GettingEL}です。
	 */
	public static final GettingEL CONTAINER_EL = new AbstractGettingEL() {
		@Override
		public Object getValue(final Object root, final Class clazz) {
			return ((EEContext) root).getContainer();
		}
	};

	/**
	 * {@link EEContext}を基点とみなして
	 * {@link EEContext#getLocal()}を返す{@link GettingEL}です。
	 */
	public static final GettingEL LOCAL_EL = new AbstractGettingEL() {
		@Override
		public Object getValue(final Object root, final Class clazz) {
			return ((EEContext) root).getLocal();
		}
	};

	/**
	 * {@link EEContext}を基点とみなして
	 * {@link EEContext#getInput()}を返す{@link GettingEL}です。
	 */
	public static final GettingEL INPUT_EL = new AbstractGettingEL() {
		@Override
		public Object getValue(final Object root, final Class clazz) {
			return ((EEContext) root).getInput();
		}
	};

	private EEUtils() {
	}
}
