/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;

/**
 * 委譲するだけの{@link Fn}です。
 * 継承クラスでアクセサ宣言を省略するメリットがあります。
 * また委譲先をプログラムで再設定するメリットがあります。
 * @author nakamura
 *
 * @param <C>
 * @param <R>
 */
public class Delegator<C, R> implements Fn<C, R> {
	private Fn<? super C, ? extends R> fn;
	
	public Delegator(final Fn<? super C, ? extends R> fn) {
		this.fn = fn;
	}
	
	public Delegator() {
	}

	public R exec(final C c) {
		return fn.exec(c);
	}

	public Fn<? super C, ? extends R> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, ? extends R> fn) {
		this.fn = fn;
	}
}
