/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import java.util.Map;
import java.util.Map.Entry;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlUtils;

/**
 * {@link Map}に格納された値とラベルの対応表を使用して
 * HTML のラジオボタンまたはチェックボックスを再生成する{@link Fn}です。
 * 
 * @author nakamura
 * 
 */
public class RadioRemaker implements Fn<NodeContext, Void> {
	private GettingEL mapEL;

	/**
	 * @param mapEL
	 *            値とラベルの{@link Map}への参照。
	 *            キー・値とも{@link Object#toString()}で文字列として扱います。
	 */
	public RadioRemaker(final GettingEL mapEL) {
		this.mapEL = mapEL;
	}

	public Void exec(final NodeContext context) {
		final Map configMap;
		{
			final Object o = mapEL.getValue(context);
			if (!(o instanceof Map)) {
				return null;
			}
			configMap = (Map) o;
		}

		final Node templateNode = context.getNode();
		XmlUtils.removeChildren(templateNode);

		for (final Object entryObject : configMap.entrySet()) {
			final Entry entry = (Entry) entryObject;
			// TODO 階層的なcloneに対応する
			final Node newNode = templateNode.cloneNode(true);
			((Element) newNode).setAttribute("value", entry.getKey()
					.toString());
			templateNode.getParentNode().insertBefore(newNode, templateNode);
			templateNode.getParentNode().insertBefore(
					XmlUtils.getDocumentNode(templateNode).createTextNode(
							entry.getValue().toString()), templateNode);
			
		}
		HtmlUtils.removeThisAndText(templateNode);
		return null;
	}

	public GettingEL getMapEL() {
		return mapEL;
	}
	public void setMapEL(final GettingEL mapEL) {
		this.mapEL = mapEL;
	}
}
