/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.misc;

import woolpack.fn.Delegator;
import woolpack.fn.Fn;

/**
 * 委譲先の実行時間を測定する{@link Fn}です。
 * 
 * @author nakamura
 * 
 * @param <C>
 * @param <R>
 */
public class LapTimeFn<C, R> extends Delegator<C, R> {
	private Fn<Long, ?> reportFn;

	/**
	 * @param fn 委譲先。
	 * @param reportFn 結果の送付先。
	 */
	public LapTimeFn(
			final Fn<? super C, ? extends R> fn,
			final Fn<Long, ?> reportFn) {
		super(fn);
		this.reportFn = reportFn;
	}

	public R exec(final C c) {
		final long s = System.currentTimeMillis();
		try {
			return super.exec(c);
		} finally {
			reportFn.exec(System.currentTimeMillis() - s);
		}
	}

	public Fn<Long, ?> getReportFn() {
		return reportFn;
	}
	public void setReportFn(final Fn<Long, ?> reportFn) {
		this.reportFn = reportFn;
	}
}
