/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.misc;

import java.util.Locale;

import woolpack.fn.Fn;
import woolpack.fn.SwitchFn;

/**
 * ユーティリティです。
 * 型推論で表記を簡略するためのスタティックメソッドを含みます。
 * 
 * @author nakamura
 *
 */
public final class MiscUtils {
	private MiscUtils() {
	}
	
	public static <C, R> LapTimeFn<C, R> lapTime(
			final Fn<? super C, ? extends R> fn,
			final Fn<Long, ?> reportFn) {
		return new LapTimeFn<C, R>(fn, reportFn);
	}
	
	public static <C, R> LoadBalancer<C, R> loadBalancer(
			final Fn<Object, ? extends Fn<? super C, ? extends R>> factory,
			final int length) {
		return new LoadBalancer<C, R>(factory, length);
	}
	
	public static <C> FnRunnable<C> fnRunnable(final Fn<? super C, ?> fn, final C c) {
		return new FnRunnable<C>(fn, c);
	}
	
	public static <R> RunnableFn<R> runnableFn(final Runnable runnable) {
		return new RunnableFn<R>(runnable);
	}
	
	public static <C, R> SleepFn<C, R> sleep(final long sleepMillis) {
		return new SleepFn<C, R>(sleepMillis);
	}
	
	public static <R> SwitchNearLocale<R> switchNearLocale(final SwitchFn<Locale, ? extends R> switching) {
		return new SwitchNearLocale<R>(switching);
	}
	
	public static <R> ThreadLocalGetter<R> threadLocal(final ThreadLocal<? extends R> threadLocal) {
		return new ThreadLocalGetter<R>(threadLocal);
	}
	
	public static <R> TryLocales<R> tryLocales(
			final Fn<? super String, ? extends R> nodeMaker,
			final ThreadLocal<Locale> threadLocal) {
		return new TryLocales<R>(nodeMaker, threadLocal);
	}
}
