/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Element;

import woolpack.fn.Fn;

/**
 * 委譲先の返却値で属性値を更新する{@link Fn}です。
 * 取得した値が null の場合は値を更新しません。
 * 
 * @author nakamura
 * 
 */
public class AttrValueUpdater<C extends NodeContext> implements Fn<C, Void> {
	private String attrName;
	private Fn<? super C, String> fn;

	public AttrValueUpdater(
			final String attrName,
			final Fn<? super C, String> fn) {
		this.attrName = attrName;
		this.fn = fn;
	}

	public Void exec(final C c) {
		final Element element = (Element) c.getNode();
		final String value = fn.exec(c);
		if (value != null) {
			element.setAttribute(attrName, value);
		}
		return null;
	}

	public String getAttrName() {
		return attrName;
	}
	public void setAttrName(final String attrName) {
		this.attrName = attrName;
	}
	public Fn<? super C, String> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, String> fn) {
		this.fn = fn;
	}
}
