/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DOM ノードを検索することができることを表します。
 * 委譲先でノードを操作した場合の次の検索結果への影響可否は実装に依存します。
 * 
 * @author nakamura
 * 
 */
public interface NodeFindable {

	/**
	 * 検索します。
	 * @param node 検索の基点。
	 * @return 検索結果。
	 */
	NodeList evaluateList(final Object node);

	/**
	 * 検索します。
	 * @param node 検索の基点。
	 * @return 検索結果。
	 */
	Node evaluateOne(final Object node);
}
