/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import woolpack.acquirable.AcquirableAllTests;
import woolpack.action.ActionAllTests;
import woolpack.adapter.AdapterAllTests;
import woolpack.bool.BoolUtilsTest;
import woolpack.config.ConfigUtilsTest;
import woolpack.container.ContainerUtilsTest;
import woolpack.convert.ConvertUtilsTest;
import woolpack.ee.EEAllTests;
import woolpack.el.ElAllTests;
import woolpack.factory.FactoryUtilsTest;
import woolpack.fn.FnUtilsTest;
import woolpack.html.HtmlAllTests;
import woolpack.id.IdUtilsTest;
import woolpack.misc.MiscUtilsTest;
import woolpack.test.TestAllTests;
import woolpack.typeconvert.TypeConvertAllTests;
import woolpack.utils.UtilsAllTests;
import woolpack.validator.ValidatorAllTests;
import woolpack.visitor.VisitorAppUtilsTest;
import woolpack.web.WebAllTests;
import woolpack.xml.XmlAllTests;

public class AllTests extends TestCase {
	public static Test suite() {
		final TestSuite suite = new TestSuite();
		suite.addTest(UtilsAllTests.suite());
		suite.addTest(new TestSuite(AccessorTest.class));
		
		suite.addTest(new TestSuite(FnUtilsTest.class));
		suite.addTest(new TestSuite(BoolUtilsTest.class));
		suite.addTest(new TestSuite(ConvertUtilsTest.class));
		suite.addTest(new TestSuite(IdUtilsTest.class));
		suite.addTest(new TestSuite(MiscUtilsTest.class));
		suite.addTest(XmlAllTests.suite());
		suite.addTest(HtmlAllTests.suite());
		suite.addTest(ValidatorAllTests.suite());
		suite.addTest(new TestSuite(VisitorAppUtilsTest.class));
		suite.addTest(new TestSuite(ConfigUtilsTest.class));
		suite.addTest(TypeConvertAllTests.suite());

		suite.addTest(ActionAllTests.suite());
		suite.addTest(AdapterAllTests.suite());
		suite.addTest(AcquirableAllTests.suite());
		suite.addTest(ElAllTests.suite());
		suite.addTest(new TestSuite(FactoryUtilsTest.class));
		suite.addTest(new TestSuite(ContainerUtilsTest.class));
		
		suite.addTest(EEAllTests.suite());
		suite.addTest(TestAllTests.suite());
		suite.addTest(WebAllTests.suite());
		return suite;
	}

	public static void main(final String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
