/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.sql.fn.PreparedStatementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapInput<R>
implements Fn<Map<String, Object>, R> {
    private DataSource dataSource;
    private Fn<? super Map<String, Object>, ? extends PreparedStatementInfo> queryFactory;
    private Fn<? super PreparedStatement, ? extends R> converter;

    public MapInput(DataSource dataSource, Fn<? super Map<String, Object>, ? extends PreparedStatementInfo> queryFactory, Fn<? super PreparedStatement, ? extends R> converter) {
        this.dataSource = dataSource;
        this.queryFactory = queryFactory;
        this.converter = converter;
    }

    public MapInput(DataSource dataSource, PreparedStatementInfo info, Fn<? super PreparedStatement, ? extends R> converter) {
        this(dataSource, FnUtils.fix(info), converter);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public R exec(Map<String, Object> c) {
        try {
            PreparedStatementInfo info = this.queryFactory.exec(c);
            Connection connection = this.dataSource.getConnection();
            try {
                R r;
                PreparedStatement statement = connection.prepareStatement(info.getQuery());
                try {
                    int i = 0;
                    while (i < info.getList().size()) {
                        statement.setObject(i + 1, c.get(info.getList().get(i)));
                        ++i;
                    }
                    statement.execute();
                    r = this.converter.exec(statement);
                }
                catch (Throwable throwable) {
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return r;
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Fn<? super Map<String, Object>, ? extends PreparedStatementInfo> getQueryFactory() {
        return this.queryFactory;
    }

    public void setQueryFactory(Fn<? super Map<String, Object>, ? extends PreparedStatementInfo> queryFactory) {
        this.queryFactory = queryFactory;
    }

    public Fn<? super PreparedStatement, ? extends R> getConverter() {
        return this.converter;
    }

    public void setConverter(Fn<? super PreparedStatement, ? extends R> converter) {
        this.converter = converter;
    }
}

