/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;


/**
 * {@link PropertyELFactory}の取得結果に対し作用させる{@link EL}です。
 * 
 * @author nakamura
 * 
 */
public class PropertyEL extends AbstractEL {
	private String propertyName;
	private PropertyELFactory factory;

	/**
	 * @param propertyName プロパティ名。
	 * @param factory プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリ。
	 */
	public PropertyEL(
			final String propertyName,
			final PropertyELFactory factory) {
		super();
		this.propertyName = propertyName;
		this.factory = factory;
	}

	/**
	 * @param propertyName プロパティ名。
	 */
	public PropertyEL(final String propertyName) {
		this(propertyName, ELUtils.PROPERTY_EL_FACTORY);
	}

	@Override
	public Object getValue(final Object root, final Class clazz) {
		return factory.newGetter(root.getClass(), propertyName).getValue(root,
				clazz);
	}

	@Override
	public void setValue(final Object root, final Object value) {
		factory.newSetter(root.getClass(), propertyName).setValue(root, value);
	}

	public PropertyELFactory getFactory() {
		return factory;
	}
	public void setFactory(final PropertyELFactory factory) {
		this.factory = factory;
	}
	public String getPropertyName() {
		return propertyName;
	}
	public void setPropertyName(final String propertyName) {
		this.propertyName = propertyName;
	}
}
