/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;

/**
 * 引数をひとつとり、返却値をひとつとる関数を表します。
 * 
 * 本インタフェースでは以下のデザインパターンを適用することができます。
 * 
 * <table border>
 * <tr><th>デザインパターン</th><th>適用方法</th></tr>
 * <tr><td>Interpreter</td><td>引数にコンテキスト役を割り当てる</td></tr>
 * <tr><td>Abstract Factory</td><td>実装で返却値を生成する</td></tr>
 * <tr><td>Composite</td><td>実装で本インタフェースの変数を宣言する</td></tr>
 * <tr><td>Proxy</td><td>委譲を制御する</td></tr>
 * <tr><td>Adapter</td><td>引数を変換して委譲する</td></tr>
 * </table>
 * 
 * @author nakamura
 *
 * @param <C> コンテキスト役。
 * @param <R> 返却値。
 */
public interface Fn<C, R> {
	/**
	 * 関数を実行します。
	 * @param c コンテキスト役。
	 * @return 返却値。
	 */
	R exec(C c);
}
