/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.fn;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import woolpack.fn.Fn;

/**
 * {@link DataSource}から{@link Connection}を取得して{@link Connection#commit()}を呼び出す{@link Fn}です。
 * {@link woolpack.sql.tx.TxBuilder#getTmpDataSource()}と組み合わせて使用します。 
 * @author nakamura
 *
 * @param <C>
 * @param <R>
 */
public class CommitFn<C, R> implements Fn<C, R> {
	private DataSource dataSource;
	
	public CommitFn(final DataSource dataSource) {
		this.dataSource = dataSource;
	}

	public R exec(final C c) {
		try {
			final Connection connection = dataSource.getConnection();
			try {
				connection.commit();
			} finally {
				connection.close();
			}
		} catch (final SQLException e) {
			throw new IllegalStateException(e);
		}
		return null;
	}

	public DataSource getDataSource() {
		return dataSource;
	}
	public void setDataSource(final DataSource dataSource) {
		this.dataSource = dataSource;
	}
}
