/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import woolpack.fn.Fn;

/**
 * {@link ConvertContext#getValue()}を委譲先で変換した結果を
 * {@link ConvertContext#setValue(Object)}に設定する{@link Fn}です。
 * @author nakamura
 *
 */
public class Converter implements Fn<ConvertContext, Void> {
	private Fn<Object, ?> fn;
	
	public Converter(final Fn<Object, ?> fn) {
		this.fn = fn;
	}
	
	public Void exec(final ConvertContext c) {
		c.setValue(fn.exec(c.getValue()));
		return null;
	}

	public Fn<Object, ?> getFn() {
		return fn;
	}
	public void setFn(final Fn<Object, ?> fn) {
		this.fn = fn;
	}
}
