/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.xml;

import woolpack.fn.Fn;


/**
 * DOMノードを再帰的にループしながら委譲する{@link Fn}です。
 * 各層をスナップショットとしてループします。
 * 
 * @author nakamura
 * 
 */
public class NodeSeeker<C extends NodeContext> extends AbstractNodeSeeker<C> {
	private Fn<? super C, Void> fn;

	public NodeSeeker(final Fn<? super C, Void> fn) {
		super();
		this.fn = fn;
	}
	
	@Override
	public Void exec(final C context) {
		fn.exec(context);
		return super.exec(context);
	}
	
	public Fn<? super C, Void> getFn() {
		return fn;
	}
	public void setFn(final Fn<? super C, Void> fn) {
		this.fn = fn;
	}
}
