/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Element;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.ELUtils;
import woolpack.el.GettingEL;
import woolpack.el.PropertyEL;
import woolpack.el.StateEL;
import woolpack.html.ValueUpdater;
import woolpack.utils.Utils;
import woolpack.xml.AbstractNodeSeeker;
import woolpack.xml.NodeContext;
import woolpack.xml.TemplateCopier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoUpdater
extends AbstractNodeSeeker<NodeContext>
implements Cloneable {
    private Iterable<String> attrNames;
    private GettingEL componentEL;
    private GettingEL configEL;
    private Collection<Class<?>> atomCollection;
    private GettingEL errorEL;
    private boolean selectFlag;

    protected AutoUpdater(Iterable<String> attrNames, GettingEL componentEL, GettingEL configEL, Collection<Class<?>> atomCollection, GettingEL errorEL, boolean selectMode) {
        this.attrNames = attrNames;
        this.componentEL = componentEL;
        this.configEL = configEL;
        this.atomCollection = atomCollection;
        this.errorEL = errorEL;
        this.selectFlag = selectMode;
    }

    public AutoUpdater(Iterable<String> attrNames, GettingEL componentEL, GettingEL configEL, Collection<Class<?>> atomCollection, GettingEL errorEL) {
        this(attrNames, componentEL, configEL, atomCollection, errorEL, true);
    }

    public AutoUpdater(Iterable<String> attrNames, GettingEL componentEL, GettingEL configEL) {
        this(attrNames, componentEL, configEL, Utils.ATOM_SET, ELUtils.NULL);
    }

    @Override
    public Void exec(NodeContext c) {
        String attrValue;
        ArrayPathEL valueEL;
        Object value;
        Element e;
        String attrName;
        if (c.getNode().getNodeType() == 1 && (attrName = this.getAttrName(e = (Element)c.getNode())) != null && (value = this.getValue(c, valueEL = new ArrayPathEL(this.componentEL, (EL)new PropertyEL(attrValue = e.getAttribute(attrName))))) != null) {
            StateEL tmpEL;
            boolean atomFlag;
            boolean collectionFlag;
            if (value instanceof Iterable) {
                collectionFlag = true;
                Iterable iterable = (Iterable)value;
                Iterator iterator = iterable.iterator();
                atomFlag = !iterator.hasNext() ? false : this.atomCollection.contains(iterator.next().getClass());
            } else if (value.getClass().isArray()) {
                collectionFlag = true;
                atomFlag = this.atomCollection.contains(value.getClass().getComponentType());
            } else {
                collectionFlag = false;
                atomFlag = this.atomCollection.contains(value.getClass());
            }
            if (atomFlag) {
                new ValueUpdater(valueEL, new ArrayPathEL(this.configEL, (EL)new PropertyEL(attrValue)), this.selectFlag).exec(c);
            } else if (collectionFlag) {
                tmpEL = new StateEL();
                AutoUpdater newUpdater = this.clone(tmpEL);
                new TemplateCopier<NodeContext>(valueEL, tmpEL, newUpdater).exec(c);
            } else {
                tmpEL = new StateEL();
                tmpEL.setValue(c, value);
                this.clone(tmpEL).exec(c);
            }
            return null;
        }
        return super.exec(c);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private AutoUpdater clone(GettingEL el) {
        AutoUpdater newUpdater;
        try {
            newUpdater = (AutoUpdater)this.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException(e1);
        }
        newUpdater.selectFlag = false;
        newUpdater.componentEL = el;
        return newUpdater;
    }

    private Object getValue(NodeContext c, GettingEL valueEL) {
        try {
            return valueEL.getValue(c);
        }
        catch (RuntimeException exception) {
            return this.errorEL.getValue(c);
        }
    }

    private String getAttrName(Element e) {
        for (String attrName : this.attrNames) {
            if (!e.hasAttribute(attrName)) continue;
            return attrName;
        }
        return null;
    }

    public Iterable<String> getAttrNames() {
        return this.attrNames;
    }

    public void setAttrNames(Iterable<String> attrNames) {
        this.attrNames = attrNames;
    }

    public GettingEL getComponentEL() {
        return this.componentEL;
    }

    public void setComponentEL(GettingEL componentEL) {
        this.componentEL = componentEL;
    }

    public GettingEL getErrorEL() {
        return this.errorEL;
    }

    public void setErrorEL(GettingEL errorEL) {
        this.errorEL = errorEL;
    }

    public GettingEL getConfigEL() {
        return this.configEL;
    }

    public void setConfigEL(GettingEL configEL) {
        this.configEL = configEL;
    }

    public Collection<Class<?>> getAtomCollection() {
        return this.atomCollection;
    }

    public void setAtomCollection(Collection<Class<?>> atomCollection) {
        this.atomCollection = atomCollection;
    }
}

