/*
 * Decompiled with CFR 0.152.
 */
package woolpack.idnode;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.bool.BoolUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.idnode.IdNodeContext;
import woolpack.xml.NodeFindable;
import woolpack.xml.NodeFindableChildNodesImpl;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFrameInserter<C extends IdNodeContext>
implements Fn<C, Void> {
    private static final NodeFindable IFRAME = new NodeFindableChildNodesImpl((Fn<Node, Boolean>)FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("IFRAME")), false);
    private static final NodeFindable BODY = new NodeFindableChildNodesImpl((Fn<Node, Boolean>)FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("BODY")), false);
    private static final NodeFindable HEAD = new NodeFindableChildNodesImpl((Fn<Node, Boolean>)FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("HEAD")), false);
    private String frameId;
    private String targetName;
    private Fn<? super C, Void> nodeMaker;
    private Fn<String, String> idConverter;

    public IFrameInserter(String frameId, String targetName, Fn<? super C, Void> nodeMaker, Fn<String, String> idConverter) {
        this.frameId = frameId;
        this.targetName = targetName;
        this.nodeMaker = nodeMaker;
        this.idConverter = idConverter;
    }

    private Node getNode(String id, C c) {
        String baseId = c.getId();
        Node baseNode = c.getNode();
        try {
            c.setId(id);
            this.nodeMaker.exec(c);
            Node node = c.getNode();
            return node;
        }
        finally {
            c.setId(baseId);
            c.setNode(baseNode);
        }
    }

    private static void importNode(Node node0, Node node1) {
        node0.getParentNode().insertBefore(XmlUtils.getDocumentNode(node0).importNode(node1, true), node0);
    }

    @Override
    public Void exec(C c) {
        Node node0 = this.getNode(this.frameId, c);
        NodeList node0IframeList = IFRAME.evaluateList(node0);
        int i = 0;
        while (i < node0IframeList.getLength()) {
            Element node0Iframe = (Element)node0IframeList.item(i);
            boolean targetFlag = this.targetName.equals(node0Iframe.getAttribute("name"));
            Node node1 = this.getNode(targetFlag ? c.getId() : this.idConverter.exec(node0Iframe.getAttribute("src")), c);
            Node node1Body = BODY.evaluateOne(node1);
            Node tmp1 = node1Body.getFirstChild();
            while (tmp1 != null) {
                IFrameInserter.importNode(node0Iframe, tmp1);
                tmp1 = tmp1.getNextSibling();
            }
            XmlUtils.removeThis(node0Iframe);
            if (targetFlag) {
                Node node0Head = HEAD.evaluateOne(node0);
                IFrameInserter.importNode(node0Head, HEAD.evaluateOne(node1));
                XmlUtils.removeThis(node0Head);
            }
            ++i;
        }
        c.setNode(node0);
        return null;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public void setFrameId(String frameId) {
        this.frameId = frameId;
    }

    public Fn<String, String> getIdConverter() {
        return this.idConverter;
    }

    public void setIdConverter(Fn<String, String> idConverter) {
        this.idConverter = idConverter;
    }

    public Fn<? super C, Void> getNodeMaker() {
        return this.nodeMaker;
    }

    public void setNodeMaker(Fn<? super C, Void> nodeMaker) {
        this.nodeMaker = nodeMaker;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }
}

