/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import woolpack.sql.adapter.DataSourceAdapter;

public class AutoCommitSettingDataSource
extends DataSourceAdapter {
    private boolean autoCommit;

    public AutoCommitSettingDataSource(DataSource parent, boolean autoCommit) {
        super(parent);
        this.autoCommit = autoCommit;
    }

    public Connection getConnection() throws SQLException {
        Connection c = super.getConnection();
        this.setAutoCommitTo(c);
        return c;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        Connection c = super.getConnection(username, password);
        this.setAutoCommitTo(c);
        return c;
    }

    private void setAutoCommitTo(Connection c) throws SQLException {
        try {
            c.setAutoCommit(this.autoCommit);
        }
        catch (SQLException e) {
            try {
                c.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw e;
        }
    }
}

