/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.fn;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementInput<C, R>
implements Fn<C, R> {
    private DataSource dataSource;
    private Fn<? super C, ? extends String> queryFactory;
    private Fn<? super Statement, ? extends R> converter;

    public StatementInput(DataSource dataSource, Fn<? super C, ? extends String> queryFactory, Fn<? super Statement, ? extends R> converter) {
        this.dataSource = dataSource;
        this.queryFactory = queryFactory;
        this.converter = converter;
    }

    public StatementInput(DataSource dataSource, String query, Fn<? super Statement, ? extends R> converter) {
        this(dataSource, FnUtils.fix(query), converter);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public R exec(C c) {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                R r;
                Statement statement = connection.createStatement();
                try {
                    statement.execute(this.queryFactory.exec(c));
                    r = this.converter.exec(statement);
                }
                catch (Throwable throwable) {
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return r;
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Fn<? super C, ? extends String> getQueryFactory() {
        return this.queryFactory;
    }

    public void setQueryFactory(Fn<? super C, ? extends String> queryFactory) {
        this.queryFactory = queryFactory;
    }

    public Fn<? super Statement, ? extends R> getConverter() {
        return this.converter;
    }

    public void setConverter(Fn<? super Statement, ? extends R> converter) {
        this.converter = converter;
    }
}

