/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.gcrud;

import java.util.Arrays;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.sql.DataSource;

import woolpack.adapter.HSQLDBUtils;
import woolpack.sql.fn.SqlFnUtils;

/**
 * {@link GcrudServlet}動作確認用にHSQLDBのメモリDBを使用するサンプルウェブアプリケーションです。
 * @author nakamura
 *
 */
public class GcrudSampleServlet extends GcrudServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;


	@Override
	public void init(final ServletConfig servletConfig) throws ServletException {
		super.init(servletConfig);
		
		// (個別処理)RDBへの接続オブジェクトを作成します(サンプルではHSQLDBのメモリDBを使用しています)。
		final DataSource dataSource = HSQLDBUtils.getDataSource(true);

		// (個別処理)テーブルを作成します(既にテーブルが存在する場合はこの処理は行ってはいけません)。
		final List<String> list = Arrays.asList(
				"CREATE TABLE MY_TABLE (" +
				"MY_ID INTEGER, " +
				"MY_SEQ INTEGER, " +
				"MY_STRING VARCHAR, " +
				"MY_INT0 INTEGER, " +
				"MY_INT1 INTEGER)",
				
				"ALTER TABLE MY_TABLE ADD PRIMARY KEY (MY_ID, MY_SEQ)",
				
				"CREATE TABLE YOUR_TABLE (" +
				"MY_INT0 INTEGER, " +
				"MY_STRING VARCHAR)",
				
				"ALTER TABLE YOUR_TABLE ADD PRIMARY KEY (MY_INT0, MY_STRING)",
				
				"ALTER TABLE MY_TABLE ADD FOREIGN KEY (MY_INT0, MY_STRING) " +
				"REFERENCES YOUR_TABLE (MY_INT0, MY_STRING)",
				
				"CREATE TABLE HIS_TABLE (" +
				"MY_INT INTEGER, " +
				"HIS_STRING VARCHAR)",
				
				"ALTER TABLE HIS_TABLE ADD PRIMARY KEY (MY_INT)",
				
				"ALTER TABLE MY_TABLE ADD FOREIGN KEY (MY_INT0) " +
				"REFERENCES HIS_TABLE (MY_INT)",
				
				"ALTER TABLE MY_TABLE ADD FOREIGN KEY (MY_INT1) " +
				"REFERENCES HIS_TABLE (MY_INT)",

				"insert into his_table(my_int, his_string) values (0, 'his0')",
				"insert into his_table(my_int, his_string) values (1, 'his1')",
				"insert into your_table(my_int0, my_string) values (0, 'my0')",
				"insert into your_table(my_int0, my_string) values (1, 'my1')",
				"insert into my_table(MY_ID, MY_SEQ, MY_STRING, MY_INT0, MY_INT1) values (0, 0, 'my0', 0, 1)",
				"insert into my_table(MY_ID, MY_SEQ, MY_STRING, MY_INT0, MY_INT1) values (0, 1, 'my1', 1, 0)"
				);
		for (final String query : list) {
			SqlFnUtils.inputStatement(
					dataSource,
					query,
					SqlFnUtils.GET_COUNT).exec(null);
		}
		
		init(dataSource);
	}
}
