/*
 * Decompiled with CFR 0.152.
 */
package woolpack.bool;

import java.util.Collection;
import java.util.regex.Pattern;
import woolpack.bool.BoolSeq;
import woolpack.bool.BooleanConverter;
import woolpack.bool.BooleanState;
import woolpack.bool.BooleanStateAndAndFactory;
import woolpack.bool.BooleanStateAndFactory;
import woolpack.bool.BooleanStateEqEqFactory;
import woolpack.bool.BooleanStateEqFactory;
import woolpack.bool.BooleanStateOrFactory;
import woolpack.bool.BooleanStateOrOrFactory;
import woolpack.bool.CompareFn;
import woolpack.bool.ContainsAllChecker;
import woolpack.bool.ContainsChecker;
import woolpack.bool.EqualsChecker;
import woolpack.bool.MaxChecker;
import woolpack.bool.MaxLengthChecker;
import woolpack.bool.MinChecker;
import woolpack.bool.MinLengthChecker;
import woolpack.bool.NotDelegator;
import woolpack.bool.NotEmptyChecker;
import woolpack.bool.NotFn;
import woolpack.bool.ObjectMatcher;
import woolpack.bool.RegExpChecker;
import woolpack.fn.FixFn;
import woolpack.fn.Fn;
import woolpack.fn.IfFn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BoolUtils {
    public static final Fn<Object, Boolean, RuntimeException> NOT_THROWABLE = BoolUtils.not(BoolUtils.matchObject(Throwable.class));
    public static final NotFn<RuntimeException> NOT = new NotFn();
    public static final NotEmptyChecker<RuntimeException> NOT_EMPTY = new NotEmptyChecker();
    public static final BooleanConverter<RuntimeException> TO_BOOLEAN = new BooleanConverter();
    public static final BooleanStateAndAndFactory ANDAND = new BooleanStateAndAndFactory();
    public static final BooleanStateAndFactory AND = new BooleanStateAndFactory();
    public static final BooleanStateEqEqFactory EQEQ = new BooleanStateEqEqFactory();
    public static final BooleanStateEqFactory EQ = new BooleanStateEqFactory();
    public static final BooleanStateOrFactory OR = new BooleanStateOrFactory();
    public static final BooleanStateOrOrFactory OROR = new BooleanStateOrOrFactory();

    private BoolUtils() {
    }

    public static <C, E extends Exception> BoolSeq<C, E> boolSeq(Fn<Object, ? extends BooleanState, ? extends RuntimeException> factory, Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable) {
        return new BoolSeq(factory, iterable);
    }

    public static <C, E extends Exception> BoolSeq<C, E> boolSeq(Iterable<? extends Fn<? super C, Boolean, ? extends E>> iterable) {
        return new BoolSeq(ANDAND, iterable);
    }

    public static <C extends Comparable<C>> CompareFn<C, RuntimeException> compare(C value) {
        return new CompareFn(value);
    }

    public static ContainsAllChecker<RuntimeException> containsAll(Collection<?> value) {
        return new ContainsAllChecker<RuntimeException>(value);
    }

    public static ContainsChecker<RuntimeException> contains(Collection<?> value) {
        return new ContainsChecker<RuntimeException>(value);
    }

    public static EqualsChecker<RuntimeException> checkEquals(Object value) {
        return new EqualsChecker<RuntimeException>(value);
    }

    public static <C extends Comparable<C>> MaxChecker<C, RuntimeException> checkMax(C value) {
        return new MaxChecker(value);
    }

    public static MaxLengthChecker<RuntimeException> checkMaxLength(int value) {
        return new MaxLengthChecker<RuntimeException>(value);
    }

    public static <C extends Comparable<C>> MinChecker<C, RuntimeException> checkMin(C value) {
        return new MinChecker(value);
    }

    public static MinLengthChecker<RuntimeException> checkMinLength(int value) {
        return new MinLengthChecker<RuntimeException>(value);
    }

    public static <C, E extends Exception> NotDelegator<C, E> not(Fn<? super C, Boolean, ? extends E> fn) {
        return new NotDelegator<C, E>(fn);
    }

    public static ObjectMatcher<RuntimeException> matchObject(Object value) {
        return new ObjectMatcher<RuntimeException>(value);
    }

    public static RegExpChecker<RuntimeException> checkRegExp(Pattern pattern) {
        return new RegExpChecker<RuntimeException>(pattern);
    }

    public static <C, E extends Exception> IfFn<C, Boolean, E> ifTrue(Fn<? super C, ?, ? extends E> ifFn, Fn<? super C, ? extends Boolean, ? extends E> trueFn) {
        return new IfFn<C, Boolean, E>(ifFn, trueFn, new FixFn(false));
    }

    public static <C, E extends Exception> IfFn<C, Boolean, E> ifNot(Fn<? super C, ?, ? extends E> ifFn, Fn<? super C, ? extends Boolean, ? extends E> falseFn) {
        return new IfFn<C, Boolean, E>(ifFn, new FixFn(true), falseFn);
    }
}

