/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.util.ArrayList;
import java.util.StringTokenizer;
import woolpack.el.AbstractEL;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.ELUtils;
import woolpack.el.MaybeEL;
import woolpack.el.PropertyEL;
import woolpack.el.PropertyELFactory;

public class PathEL
extends AbstractEL {
    private String expression;
    private PropertyELFactory factory;
    private EL el;
    private boolean notFoundIgnoreFlag;

    public PathEL(String expression, PropertyELFactory factory, boolean notFoundIgnoreFlag) {
        this.expression = expression;
        this.factory = factory;
        this.notFoundIgnoreFlag = notFoundIgnoreFlag;
        this.generate();
    }

    private void generate() {
        StringTokenizer st = new StringTokenizer(this.expression, ".");
        ArrayList<AbstractEL> c = new ArrayList<AbstractEL>();
        while (st.hasMoreTokens()) {
            PropertyEL tmpEL = new PropertyEL(st.nextToken(), this.factory);
            if (this.notFoundIgnoreFlag) {
                c.add(new MaybeEL(tmpEL));
                continue;
            }
            c.add(tmpEL);
        }
        this.el = new ArrayPathEL(c);
    }

    public PathEL(String expression, boolean notFoundIgnoreFlag) {
        this(expression, ELUtils.getPropertyELFactory(notFoundIgnoreFlag), notFoundIgnoreFlag);
    }

    public PathEL(String expression) {
        this(expression, true);
    }

    public Object getValue(Object root, Class clazz) {
        return this.el.getValue(root, clazz);
    }

    public boolean setValue(Object root, Object value) {
        return this.el.setValue(root, value);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.generate();
    }

    public PropertyELFactory getFactory() {
        return this.factory;
    }

    public void setFactory(PropertyELFactory factory) {
        this.factory = factory;
        this.generate();
    }

    public boolean isNotFoundIgnoreFlag() {
        return this.notFoundIgnoreFlag;
    }

    public void setNotFoundIgnoreFlag(boolean notFoundIgnoreFlag) {
        this.notFoundIgnoreFlag = notFoundIgnoreFlag;
        this.generate();
    }
}

