/*
 * Decompiled with CFR 0.152.
 */
package woolpack.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamReaderFactory<C>
implements Fn<C, Reader, IOException> {
    private Fn<? super C, ? extends InputStream, ? extends IOException> inputStreamFactory;
    private String charset;

    public InputStreamReaderFactory(Fn<? super C, ? extends InputStream, ? extends IOException> inputStreamFactory, String charset) {
        this.inputStreamFactory = inputStreamFactory;
        this.charset = charset;
    }

    @Override
    public Reader exec(C c) throws IOException {
        InputStream stream = this.inputStreamFactory.exec(c);
        if (stream == null) {
            return null;
        }
        try {
            if (this.charset == null || this.charset.length() == 0) {
                return new BufferedReader(new InputStreamReader(stream));
            }
            return new BufferedReader(new InputStreamReader(stream, this.charset));
        }
        catch (IOException e) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Fn<? super C, ? extends InputStream, ? extends IOException> getInputStreamFactory() {
        return this.inputStreamFactory;
    }

    public void setInputStreamFactory(Fn<? super C, ? extends InputStream, ? extends IOException> inputStreamFactory) {
        this.inputStreamFactory = inputStreamFactory;
    }
}

