/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.Collection;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.bool.BoolUtils;
import woolpack.convert.ConvertUtils;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.html.AutoUpdater;
import woolpack.html.BranchPropertyCounter;
import woolpack.html.CaseNormalizer;
import woolpack.html.CommentRemover;
import woolpack.html.HiddenAppender;
import woolpack.html.MergeCell;
import woolpack.html.MergeCellAll;
import woolpack.html.RadioRemaker;
import woolpack.html.RowAttrConverter;
import woolpack.html.RowIndexInserter;
import woolpack.html.SelectRemaker;
import woolpack.html.SelectedValueUpdater;
import woolpack.html.SpaceCompressor;
import woolpack.html.ThisAndTextsRemover;
import woolpack.html.ValueUpdater;
import woolpack.xml.NodeContext;
import woolpack.xml.NodeFindUtils;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlUtils {
    public static final Fn<NodeContext, Void, RuntimeException> COMPRESS_SPACE = new SpaceCompressor<RuntimeException>();
    public static final Fn<NodeContext, Void, RuntimeException> MERGE_CELL_ALL = new MergeCellAll<RuntimeException>();
    public static final Fn<NodeContext, Void, RuntimeException> NORMALIZE_CASE = new CaseNormalizer<RuntimeException>();
    public static final Fn<NodeContext, Void, RuntimeException> REMOVE_COMMENT = new CommentRemover<RuntimeException>();
    public static final Fn<NodeContext, Void, RuntimeException> REMOVE_THIS_AND_TEXTS = new ThisAndTextsRemover<RuntimeException>();
    static final Fn<Node, NodeList, RuntimeException> TR_LIST = NodeFindUtils.list(FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("TR")), false);
    static final Fn<Node, Node, RuntimeException> TR_ONE = NodeFindUtils.one(FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("TR")));
    static final Fn<Node, NodeList, RuntimeException> TD_LIST = NodeFindUtils.list(FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("TD")), false);

    private HtmlUtils() {
    }

    public static void removeThisAndText(Node node) {
        Node nextNode = node.getNextSibling();
        while (nextNode != null && nextNode.getNodeType() == 3) {
            XmlUtils.removeThis(nextNode);
            nextNode = node.getNextSibling();
        }
        XmlUtils.removeThis(node);
    }

    public static Fn<NodeContext, Void, RuntimeException> updateAuto(Iterable<String> attrNames, GettingEL componentEL, GettingEL configEL, Collection<Class<?>> atomCollection, GettingEL errorEL) {
        return new AutoUpdater<RuntimeException>(attrNames, componentEL, configEL, atomCollection, errorEL);
    }

    public static Fn<NodeContext, Void, RuntimeException> updateAuto(Iterable<String> attrNames, GettingEL componentEL, GettingEL configEL) {
        return new AutoUpdater<RuntimeException>(attrNames, componentEL, configEL);
    }

    public static <C extends NodeContext, E extends Exception> Fn<C, Void, E> branchPropertyCount(EL el, Iterable<String> attrNames, Fn<? super C, Void, ? extends E> firstFn, Fn<? super C, Void, ? extends E> pluralFn) {
        return new BranchPropertyCounter<C, E>(el, attrNames, firstFn, pluralFn);
    }

    public static Fn<NodeContext, Void, RuntimeException> convertRowAttr(String attrName, String[] attrValueArray) {
        return new RowAttrConverter<RuntimeException>(attrName, attrValueArray);
    }

    public static Fn<NodeContext, Void, RuntimeException> hiddenAllToChild(GettingEL mapEL, Collection<String> excludeProperties) {
        return new HiddenAppender<RuntimeException>(mapEL, excludeProperties);
    }

    public static Fn<NodeContext, Void, RuntimeException> insertRowIndex(String headValue) {
        return new RowIndexInserter<RuntimeException>(headValue);
    }

    public static Fn<NodeContext, Void, RuntimeException> makeRadio(GettingEL mapEL) {
        return new RadioRemaker<RuntimeException>(mapEL);
    }

    public static Fn<NodeContext, Void, RuntimeException> makeSelect(GettingEL mapEL) {
        return new SelectRemaker<RuntimeException>(mapEL);
    }

    public static Fn<NodeContext, Void, RuntimeException> mergeCell(int colIndex) {
        return new MergeCell<RuntimeException>(colIndex);
    }

    public static Fn<NodeContext, Void, RuntimeException> updateToSelectedValue(GettingEL valueEL, GettingEL mapEL) {
        return new SelectedValueUpdater<RuntimeException>(valueEL, mapEL);
    }

    public static Fn<NodeContext, Void, RuntimeException> updateValue(GettingEL valueEL, GettingEL mapEL, boolean selectFlag) {
        return new ValueUpdater<RuntimeException>(valueEL, mapEL, selectFlag);
    }

    public static ValueUpdater<RuntimeException> updateValue(GettingEL valueEL, GettingEL mapEL) {
        return new ValueUpdater<RuntimeException>(valueEL, mapEL, true);
    }

    public static ValueUpdater<RuntimeException> updateValue(GettingEL valueEL) {
        return new ValueUpdater<RuntimeException>(valueEL, null, true);
    }

    public static Fn<NodeContext, Void, RuntimeException> removeExtension(final String elementName, final String attrName) {
        return XmlUtils.findNode(NodeFindUtils.list(new Fn<Node, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Node c) {
                if (c.getNodeType() == 1 && elementName.equals(c.getNodeName()) && ((Element)c).hasAttribute(attrName)) {
                    return true;
                }
                return false;
            }
        }, true), XmlUtils.updateAttrValue(attrName, FnUtils.join(XmlUtils.getAttrValue(attrName), ConvertUtils.convertRegExp(Pattern.compile("^([^\\.]+)\\.[^\\.]+$"), "$1"))));
    }
}

