/*
 * Decompiled with CFR 0.152.
 */
package woolpack.misc;

import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryFn<C, R, E extends Exception>
implements Fn<C, R, E> {
    private Fn<? super C, ? extends R, ? extends Exception> fn;
    private int count;
    private Fn<? super Exception, ?, ? extends E> errorFn;
    private Fn<? super Exception, ? extends R, ? extends E> finalFn;

    public RetryFn(Fn<? super C, ? extends R, ? extends Exception> fn, int count, Fn<? super Exception, ?, ? extends E> errorFn, Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        this.fn = fn;
        this.count = count;
        this.errorFn = errorFn;
        this.finalFn = finalFn;
    }

    @Override
    public R exec(C c) throws E {
        Exception t = null;
        int i = 0;
        while (i < this.count) {
            try {
                return this.fn.exec(c);
            }
            catch (Exception e) {
                t = e;
                this.errorFn.exec(t);
                ++i;
            }
        }
        return this.finalFn.exec(t);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Fn<? super Exception, ?, ? extends E> getErrorFn() {
        return this.errorFn;
    }

    public void setErrorFn(Fn<? super Exception, ?, ? extends E> errorFn) {
        this.errorFn = errorFn;
    }

    public Fn<? super Exception, ? extends R, ? extends E> getFinalFn() {
        return this.finalFn;
    }

    public void setFinalFn(Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        this.finalFn = finalFn;
    }

    public Fn<? super C, ? extends R, ? extends Exception> getFn() {
        return this.fn;
    }

    public void setFn(Fn<? super C, ? extends R, ? extends Exception> fn) {
        this.fn = fn;
    }
}

