/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.bool;

abstract public class BooleanState {
	private boolean current;
	private boolean stopped;
	
	protected BooleanState(final boolean current) {
		this.current = current;
		this.stopped = false;
	}
	
	abstract public void in(boolean flag);
	
	protected void setStopped(final boolean stopped) {
		this.stopped = stopped;
	}
	public boolean isStopped() {
		return stopped;
	}
	protected void setCurrent(final boolean current) {
		this.current = current;
	}
	public boolean isCurrent(){
		return current;
	}
}
