/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Locale;
import java.util.ResourceBundle;

import woolpack.fn.Fn;

/**
 * {@link ThreadLocal}から{@link Locale}を取得して使用する{@link ResourceBundle}のファクトリです。
 * @author nakamura
 *
 * @param <E>
 */
public class ResourceBundleFactory<E extends Exception> implements Fn<Object, ResourceBundle, E> {
	private String path;
	private ThreadLocal<Locale> threadLocal;
	
	public ResourceBundleFactory(
			final String path,
			final ThreadLocal<Locale> threadLocal) {
		this.path = path;
		this.threadLocal = threadLocal;
	}

	public ResourceBundle exec(final Object c) {
		final Locale l = threadLocal.get();
		return (l != null) ? ResourceBundle.getBundle(path, l) : ResourceBundle.getBundle(path);
	}

	public String getPath() {
		return path;
	}
	public void setPath(final String path) {
		this.path = path;
	}
	public ThreadLocal<Locale> getThreadLocal() {
		return threadLocal;
	}
	public void setThreadLocal(final ThreadLocal<Locale> threadLocal) {
		this.threadLocal = threadLocal;
	}
}
