/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import java.math.BigDecimal;
import java.math.BigInteger;

import woolpack.fn.Fn;

/**
 * 入力を{@link Number}にキャストして
 * {@link BigDecimal}に変換する{@link Fn}です。
 * このクラスは LSP(The Liskov Substitution Principle) を満たしません。
 * @author nakamura
 *
 * @param <E>
 */
public class ToBigIntegerConverter<E extends Exception> implements Fn<Object, BigInteger, E> {
	/**
	 * @throws ClassCastException 引数が{@link Number}でない場合。
	 * @throws ArithmeticException 引数が型の範囲外の場合。
	 */
	public BigInteger exec(final Object c) {
		if (c instanceof BigInteger) {
			return (BigInteger) c;
		}
		if (c instanceof BigDecimal) {
			return ((BigDecimal) c).toBigIntegerExact();
		} else {
			return new BigDecimal(((Number) c).doubleValue()).toBigIntegerExact();
		}
	}
}
