/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;

public class IfFn<C, R, E extends Exception> implements Fn<C, R, E> {
	private Fn<? super C, ?, ? extends E> ifFn;
	private Fn<? super C, ? extends R, ? extends E> trueFn;
	private Fn<? super C, ? extends R, ? extends E> falseFn;
	
	public IfFn(
			final Fn<? super C, ?, ? extends E> ifFn,
			final Fn<? super C, ? extends R, ? extends E> trueFn,
			final Fn<? super C, ? extends R, ? extends E> falseFn) {
		this.ifFn = ifFn;
		this.trueFn = trueFn;
		this.falseFn = falseFn;
	}

	public R exec(final C c) throws E {
		final Object o = ifFn.exec(c);
		if (Boolean.TRUE.equals(o)) {
			return trueFn.exec(c);
		} else {
			return falseFn.exec(c);
		}
	}

	public Fn<? super C, ?, ? extends E> getIfFn() {
		return ifFn;
	}
	public void setIfFn(final Fn<? super C, ?, ? extends E> ifFn) {
		this.ifFn = ifFn;
	}
	public Fn<? super C, ? extends R, ? extends E> getTrueFn() {
		return trueFn;
	}
	public void setTrueFn(final Fn<? super C, ? extends R, ? extends E> trueFn) {
		this.trueFn = trueFn;
	}
	public Fn<? super C, ? extends R, ? extends E> getFalseFn() {
		return falseFn;
	}
	public void setFalseFn(final Fn<? super C, ? extends R, ? extends E> falseFn) {
		this.falseFn = falseFn;
	}
}
