/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.fn;

public class JoinFn<A, B, C, E extends Exception> implements Fn<A, C, E> {
	private Fn<? super A, ? extends B, ? extends E> firstFn;
	private Fn<? super B, ? extends C, ? extends E> secondFn;
	
	public JoinFn(
			final Fn<? super A, ? extends B, ? extends E> firstFn,
			final Fn<? super B, ? extends C, ? extends E> secondFn) {
		this.firstFn = firstFn;
		this.secondFn = secondFn;
	}

	public C exec(final A a) throws E {
		return secondFn.exec(firstFn.exec(a));
	}
	
	public Fn<? super A, ? extends B, ? extends E> getFirstFn() {
		return firstFn;
	}
	public void setFirstFn(final Fn<? super A, ? extends B, ? extends E> firstFn) {
		this.firstFn = firstFn;
	}
	public Fn<? super B, ? extends C, ? extends E> getSecondFn() {
		return secondFn;
	}
	public void setSecondFn(final Fn<? super B, ? extends C, ? extends E> secondFn) {
		this.secondFn = secondFn;
	}
}
