/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import woolpack.fn.Delegator;
import woolpack.fn.Fn;

/**
 * {@link ConvertContext#setFn(Fn)}に委譲先を設定した後に委譲する関数です。
 * <br/>適用しているデザインパターン：Double Dispatch。
 * 
 * @author nakamura
 *
 */
public class SettingFnConverter extends Delegator<ConvertContext, Void, RuntimeException> {
	
	/**
	 * 
	 * @param fn 委譲先。
	 */
	public SettingFnConverter(
			final Fn<? super ConvertContext, Void, ? extends RuntimeException> fn) {
		super(fn);
	}

	@Override
	public Void exec(final ConvertContext c) {
		c.setFn(this);
		super.exec(c);
		return null;
	}
}
