/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import woolpack.adapter.XPathLoadTest;
import woolpack.xml.XmlTransformerFactoryLoadTest;

public class LoadAllTests extends TestCase {

	public static final int MAX_CONCURRENT = 2;

	public static final int MAX_THREAD = 5;

	public static final int TEST_COUNT = 2000;

	public static final int TEST_THRESHOLD = 200;

	public static final ExecutorService THREAD_POOL = Executors
			.newFixedThreadPool(LoadAllTests.MAX_THREAD);

	public static Test suite() {
		final TestSuite suite = new TestSuite();

		suite.addTest(new TestSuite(XmlTransformerFactoryLoadTest.class));
		suite.addTest(new TestSuite(XPathLoadTest.class));

		return suite;
	}
}
