/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import javax.xml.transform.TransformerException;

import junit.framework.TestCase;

import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import woolpack.xml.XmlTransformerUtils;

public class JXPUtilsTest extends TestCase {
	private Node generateSampleNode() throws TransformerException {
		return XmlTransformerUtils.convert("<HTML><BODY><SPAN id=\"id0\"/><SPAN id=\"id1\"/></BODY></HTML>");
	}

	public void testEvaluateList() throws TransformerException {
		final Node node = generateSampleNode();
		final NodeList list = JXPUtils.list("//SPAN/@id").exec(node);
		assertEquals(2, list.getLength());
		assertTrue(list.item(0) instanceof Attr);
		assertEquals("id0", list.item(0).getNodeValue());
		assertTrue(list.item(1) instanceof Attr);
		assertEquals("id1", list.item(1).getNodeValue());
	}

	public void testEvaluateListNotFound() throws TransformerException {
		final Node node = generateSampleNode();
		final NodeList list = JXPUtils.list("//SPAN/@ie").exec(node);
		assertEquals(0, list.getLength());
	}

	public void testEvaluateOne() throws TransformerException {
		final Node node = generateSampleNode();
		final Node result = JXPUtils.one("//SPAN/@id").exec(node);
		assertTrue(result instanceof Attr);
		assertEquals("id0", result.getNodeValue());
	}

	public void testEvaluateOneNotFound() throws TransformerException {
		final Node node = generateSampleNode();
		final Node result = JXPUtils.one("//SPAN/@ie").exec(node);
		assertNull(result);
	}
}
