/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import java.text.ParseException;

import junit.framework.TestCase;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;

public class ToTypeConverterTest extends TestCase {
	private final Fn<ConvertContext, Void, RuntimeException> fn = new ToTypeConverter(
			FnUtils.<Class, Class>fix(void.class)
	);
	
	public void testNormal() throws ParseException {
		final ConvertContext context = new ConvertContext();
		context.setFn(fn);
		context.setToType(Integer.class);
		context.setPropertyName("myname");
		context.setValue("oh");
		fn.exec(context);
		assertEquals(void.class, context.getToType());
	}
}
