/*
 * Decompiled with CFR 0.152.
 */
package woolpack.acquirable;

import java.util.List;
import woolpack.acquirable.Acquirable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquirableChain<E extends Exception>
implements Acquirable<E> {
    private List<? extends Acquirable<? extends E>> list;

    public AcquirableChain(List<? extends Acquirable<? extends E>> list) {
        this.list = list;
    }

    @Override
    public boolean acquire() throws E {
        int length = this.list.size();
        int i = 0;
        try {
            while (i < length) {
                if (!this.list.get(i).acquire()) {
                    break;
                }
                ++i;
            }
        }
        finally {
            if (i < length) {
                this.release(i - 1);
            }
        }
        return i >= length;
    }

    private void release(int length) {
        int i = length;
        while (i >= 0) {
            this.list.get(i).release();
            --i;
        }
    }

    @Override
    public void release() {
        this.release(this.list.size() - 1);
    }

    public List<? extends Acquirable<? extends E>> getList() {
        return this.list;
    }

    public void setList(List<? extends Acquirable<? extends E>> list) {
        this.list = list;
    }
}

