/*
 * Decompiled with CFR 0.152.
 */
package woolpack.convert;

import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrysFn<C, R, E extends Exception>
implements Fn<C, R, E> {
    private Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable;
    private Fn<? super Exception, ?, ? extends E> errorFn;
    private Fn<? super Exception, ? extends R, ? extends E> finalFn;

    public TrysFn(Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable, Fn<? super Exception, ?, ? extends E> errorFn, Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        this.iterable = iterable;
        this.errorFn = errorFn;
        this.finalFn = finalFn;
    }

    @Override
    public R exec(C c) throws E {
        Exception t = null;
        for (Fn<C, R, Exception> fn : this.iterable) {
            try {
                return fn.exec(c);
            }
            catch (Exception e) {
                t = e;
                this.errorFn.exec(t);
            }
        }
        return this.finalFn.exec(t);
    }

    public Fn<? super Exception, ?, ? extends E> getErrorFn() {
        return this.errorFn;
    }

    public void setErrorFn(Fn<? super Exception, ?, ? extends E> errorFn) {
        this.errorFn = errorFn;
    }

    public Fn<? super Exception, ? extends R, ? extends E> getFinalFn() {
        return this.finalFn;
    }

    public void setFinalFn(Fn<? super Exception, ? extends R, ? extends E> finalFn) {
        this.finalFn = finalFn;
    }

    public Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> getIterable() {
        return this.iterable;
    }

    public void setIterable(Iterable<? extends Fn<? super C, ? extends R, ? extends Exception>> iterable) {
        this.iterable = iterable;
    }
}

