/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.bool.BoolUtils;
import woolpack.ee.EEContext;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.utils.Utils;
import woolpack.xml.NodeFindUtils;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionBuilder {
    private static final int TOKEN_LENGTH = 32;
    private static final int DEGIT_COUNT = 10;
    private static final int TOKEN_CHAR_COUNT = 36;
    public static final String KEY = "woolpack.transaction.TRANSACTION_TOKEN";
    private final String key;
    private final Random r;
    private final Collection<String> idCollection;
    private final int size;
    private final Fn<Node, NodeList, RuntimeException> xpathForm;
    private final Fn<Node, NodeList, RuntimeException> xpathHref;

    public TransactionBuilder(String key, Collection<String> idCollection, int size) throws Exception {
        this.key = key;
        this.r = new Random();
        this.idCollection = idCollection;
        this.size = size;
        this.xpathForm = NodeFindUtils.list(FnUtils.join(XmlUtils.GET_NODE_NAME, BoolUtils.checkEquals("FORM")), false);
        this.xpathHref = NodeFindUtils.list(new Fn<Node, Boolean, RuntimeException>(){

            @Override
            public Boolean exec(Node c) {
                if (c.getNodeType() == 1 && "A".equals(c.getNodeName()) && ((Element)c).hasAttribute("href")) {
                    return true;
                }
                return false;
            }
        }, false);
    }

    public TransactionBuilder(Collection<String> idCollection) throws Exception {
        this(KEY, idCollection, 32);
    }

    String generateToken() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size) {
            int j = this.r.nextInt(36);
            sb.append(j < 10 ? (char)(48 + j) : (char)(65 + j - 10));
            ++i;
        }
        return sb.toString();
    }

    public <E extends Exception> Fn<EEContext, Void, E> getCheckExpression(final Fn<? super EEContext, Void, ? extends E> trueExpression, final Fn<? super EEContext, Void, ? extends E> falseExpression) {
        return new Fn<EEContext, Void, E>(){

            @Override
            public Void exec(EEContext context) throws Exception {
                if (TransactionBuilder.this.idCollection.contains(context.getId())) {
                    Object oldToken = context.getSession().get(TransactionBuilder.this.key);
                    List<?> requestedTokens = Utils.toList(context.getInput().get(TransactionBuilder.this.key));
                    String newToken = TransactionBuilder.this.generateToken();
                    if (oldToken != null && oldToken.equals(requestedTokens.get(0)) && context.getSession().replace(TransactionBuilder.this.key, oldToken, newToken)) {
                        trueExpression.exec(context);
                    } else {
                        falseExpression.exec(context);
                    }
                } else {
                    String newToken;
                    Object oldToken;
                    do {
                        oldToken = context.getSession().get(TransactionBuilder.this.key);
                        newToken = TransactionBuilder.this.generateToken();
                    } while (!(oldToken == null ? context.getSession().putIfAbsent(TransactionBuilder.this.key, newToken) == null : context.getSession().replace(TransactionBuilder.this.key, oldToken, newToken)));
                    trueExpression.exec(context);
                }
                return null;
            }
        };
    }

    public Fn<EEContext, Void, RuntimeException> getAppendExpression() {
        return FnUtils.seq((Iterable)Utils.list(XmlUtils.findNode(this.xpathForm, new Fn<EEContext, Void, RuntimeException>(){

            @Override
            public Void exec(EEContext context) {
                String token = (String)context.getSession().get(TransactionBuilder.this.key);
                if (token != null) {
                    Element element = XmlUtils.getDocumentNode(context.getNode()).createElement("INPUT");
                    element.setAttribute("type", "hidden");
                    element.setAttribute("name", TransactionBuilder.this.key);
                    element.setAttribute("value", token);
                    context.getNode().appendChild(element);
                }
                return null;
            }
        })).list(XmlUtils.findNode(this.xpathHref, new Fn<EEContext, Void, RuntimeException>(){

            @Override
            public Void exec(EEContext context) {
                String token = (String)context.getSession().get(TransactionBuilder.this.key);
                if (token != null) {
                    Element element = (Element)context.getNode();
                    String href = element.getAttribute("href");
                    String newHref = String.valueOf(href) + (href.indexOf(63) >= 0 ? (char)'&' : '?') + TransactionBuilder.this.key + '=' + token;
                    element.setAttribute("href", newHref);
                }
                return null;
            }
        })));
    }

    public Collection<String> getIdCollection() {
        return Collections.unmodifiableCollection(this.idCollection);
    }

    public String getKey() {
        return this.key;
    }
}

