/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.fn.Fn;
import woolpack.sql.convert.ParamBindInfo;
import woolpack.sql.convert.SqlOperator;
import woolpack.sql.fn.PreparedStatementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlColumnUtils {
    private static final Pattern WHERE_PATTERN = Pattern.compile("\\s+where\\s+", 2);
    private static final Pattern INSERT_COLS_PATTERN = Pattern.compile("\\(([^\\)]+)\\)", 2);
    private static final Pattern INSERT_HEADER_PATTERN = Pattern.compile("^insert\\s+into\\s+", 2);
    public static final Fn<List<String>, Fn<ParamBindInfo, Void, RuntimeException>, RuntimeException> APPEND_NAME = new Fn<List<String>, Fn<ParamBindInfo, Void, RuntimeException>, RuntimeException>(){

        @Override
        public Fn<ParamBindInfo, Void, RuntimeException> exec(final List<String> list) {
            return new Fn<ParamBindInfo, Void, RuntimeException>(){

                @Override
                public Void exec(ParamBindInfo info) {
                    int count = SqlColumnUtils.count(info.getBindString(), '?');
                    if (count == 1) {
                        list.add(info.getName());
                    } else {
                        int i = 0;
                        while (i < count) {
                            list.add(String.valueOf(info.getName()) + '_' + i);
                            ++i;
                        }
                    }
                    return null;
                }
            };
        }
    };
    public static final Fn<List<String>, Fn<ParamBindInfo, Void, RuntimeException>, RuntimeException> APPEND_NAME_WITH_OPERATOR = new Fn<List<String>, Fn<ParamBindInfo, Void, RuntimeException>, RuntimeException>(){

        @Override
        public Fn<ParamBindInfo, Void, RuntimeException> exec(final List<String> list) {
            return new Fn<ParamBindInfo, Void, RuntimeException>(){

                @Override
                public Void exec(ParamBindInfo info) {
                    if (info.getOperator() == null || !info.isWhereFlag()) {
                        list.add(info.getName());
                    } else {
                        int count = SqlColumnUtils.count(info.getBindString(), '?');
                        if (count == 1) {
                            list.add(String.valueOf(info.getName()) + '_' + info.getOperator().getLabel());
                        } else {
                            int i = 0;
                            while (i < count) {
                                list.add(String.valueOf(info.getName()) + '_' + info.getOperator().getLabel() + i);
                                ++i;
                            }
                        }
                    }
                    return null;
                }
            };
        }
    };

    private static int count(String s, char c) {
        int count = 0;
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (s.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private SqlColumnUtils() {
    }

    public static List<ParamBindInfo> getNotInsertList(String s) {
        Matcher matcher = WHERE_PATTERN.matcher(s);
        int whereIndex = matcher.find() ? matcher.start() : -1;
        ArrayList<ParamBindInfo> list = new ArrayList<ParamBindInfo>();
        SqlOperator[] sqlOperatorArray = SqlOperator.values();
        int n = 0;
        int n2 = sqlOperatorArray.length;
        while (n < n2) {
            SqlOperator operator = sqlOperatorArray[n];
            Matcher matcher2 = operator.getPattern().matcher(s);
            while (matcher2.find()) {
                int index = matcher2.start();
                list.add(new ParamBindInfo(matcher2.group(1), index, matcher2.end(), matcher2.group(2), operator, whereIndex < index));
            }
            ++n;
        }
        Collections.sort(list, ParamBindInfo.COMPARATOR);
        return list;
    }

    public static List<ParamBindInfo> getInsertList(String s) {
        Matcher matcher = INSERT_COLS_PATTERN.matcher(s);
        if (!matcher.find()) {
            return null;
        }
        String[] colArray = matcher.group(1).split("[\\s,]+");
        ArrayList<ParamBindInfo> list = new ArrayList<ParamBindInfo>();
        String[] stringArray = colArray;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String col = stringArray[n];
            list.add(new ParamBindInfo(col));
            ++n;
        }
        return list;
    }

    public static List<ParamBindInfo> getList(String s) {
        return INSERT_HEADER_PATTERN.matcher(s).find() ? SqlColumnUtils.getInsertList(s) : SqlColumnUtils.getNotInsertList(s);
    }

    public static PreparedStatementInfo toPreparedStatementInfo(String s, Fn<? super List<String>, ? extends Fn<? super ParamBindInfo, Void, ? extends RuntimeException>, ? extends RuntimeException> fn) {
        PreparedStatementInfo info = new PreparedStatementInfo();
        List<ParamBindInfo> bindInfoList = SqlColumnUtils.getList(s);
        ArrayList<String> list = new ArrayList<String>(bindInfoList.size());
        info.setList(list);
        Fn<? super ParamBindInfo, Void, ? extends RuntimeException> appender = fn.exec(list);
        for (ParamBindInfo bindInfo : bindInfoList) {
            appender.exec(bindInfo);
        }
        info.setQuery(s);
        return info;
    }
}

