/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.hellomain;

import java.io.IOException;
import java.util.Arrays;

import javax.xml.transform.TransformerException;

import woolpack.el.PathEL;
import woolpack.fn.Fn;
import woolpack.html.HtmlUtils;
import woolpack.utils.Utils;
import woolpack.xml.MapNodeContext;
import woolpack.xml.NodeContext;
import woolpack.xml.XmlTransformerUtils;

/**
 * Woolpack の サンプル main アプリケーションです。
 * @author nakamura
 *
 */
public final class Hello {
	private Hello() {
	}
	
	public static void main(final String[] args) throws IOException, TransformerException {
		final MapNodeContext context = new MapNodeContext();
		
		// 流し込む対象を設定します。
		context.setNode(XmlTransformerUtils.convert(
				"<HTML><BODY><FORM><TABLE><TR id=\"list0\">"
				+ "<TD><TEXTAREA name=\"textarea0\" >value0</TEXTAREA></TD>"
				+ "<TD><DIV id=\"div0\" >value0</DIV></TD>"
				+ "<TD><SPAN id=\"span0\" >value0</SPAN></TD>"
				+ "<TD><INPUT name=\"input0\" value=\"value0\" /></TD>"
				+ "<TD><SPAN id=\"span1\" >spanvalue1</SPAN></TD>"
				+ "</TR></TABLE></FORM></BODY></HTML>"));
		
		// 流し込むデータを設定します。
		context.setMap(Utils.map("list0", Utils
				.list(Utils
						.map("textarea0", "textareavalue0")
						.map("div0", "divvalue0")
						.map("span0", "spanvalue0")
						.map("input0", "inputvalue0"))
				.list(Utils
						.map("textarea0", "textareavalue1")
						.map("div0", "divvalue1")
						.map("span0", "spanvalue1")
						.map("input0", "inputvalue1"))));

		final Fn<NodeContext, Void, RuntimeException> expression = HtmlUtils.updateAuto(
				Arrays.asList("name", "id"), new PathEL("map"), null);
		expression.exec(context);
		System.out.println(XmlTransformerUtils.convert(context.getNode()));
	}
}
