/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.transaction;

import java.util.Arrays;

import junit.framework.TestCase;
import woolpack.adapter.JXPUtils;
import woolpack.samples.SamplesAllTests;
import woolpack.test.TestDomContextBuilder;
import woolpack.test.TestUtils;

public class TransactionServletTest extends TestCase {

	public void testForm() throws Exception {
		final TransactionServlet servlet = new TransactionServlet();
		servlet.toNode.setFn(SamplesAllTests.getFileToNode("^(.*)$", "html/sample/transaction/$1.html"));
		final TestDomContextBuilder builder = new TestDomContextBuilder(JXPUtils.ONE);
		
		builder.get().setId("0");
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'0\']"));
		builder.initXPath("//FORM");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));

		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'1\']"));
		builder.initXPath("//FORM");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));
		
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'2\']"));
		builder.initXPath("//FORM");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));
		
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'0\']"));
		builder.initXPath("//FORM");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));
		
		builder.getInput().get("woolpack.transaction.TRANSACTION_TOKEN").set(0, "hoge");
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//BODY[contains(text()[2], \'invalid transaction\')]"));
	}

	public void testAncher() throws Exception {
		final TransactionServlet servlet = new TransactionServlet();
		servlet.toNode.setFn(SamplesAllTests.getFileToNode("^(.*)$", "html/sample/transaction/$1.html"));
		final TestDomContextBuilder builder = new TestDomContextBuilder(JXPUtils.ONE);
		
		builder.get().setId("0");
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'0\']"));
		builder.initXPath("//A");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));

		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'1\']"));
		builder.initXPath("//A");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));
		
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'2\']"));
		builder.initXPath("//A");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));
		
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//H4[text() = \'0\']"));
		builder.initXPath("//A");
		assertTrue(TestUtils.equals(Arrays.asList("woolpack.transaction.TRANSACTION_TOKEN"), builder.getInput().keySet()));
		
		builder.getInput().get("woolpack.transaction.TRANSACTION_TOKEN").set(0, "hoge");
		servlet.fn.exec(builder.get());
		assertTrue(builder.exists("//BODY[contains(text()[2], \'invalid transaction\')]"));
	}
}
