/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

var validator_flag = true;

function checkAndAlert(form){
	if(!validator_flag){
		return true;
	}
	var id = form.getAttribute("action");
	id = id.replace("(.+)\\.[^\\.]+", "$1");
	
	var context = new ValidatorContext();
	context.collectable = new SimpleMessageCollector();
	context.id = id;
	context.inputMap = convertFormToListMap(form);
	var flag = validator_tree.exec(context);
	if(!flag){
		var sb = "";
		for(var i in context.collectable.messageList){
			sb = sb + "\n" + context.collectable.messageList[i];
		}
		alert(sb);
	}
	return flag;
}

var validator_tree = 
new BoolSeq(new BooleanStateAndAndFactory(),[new IfFn(new JoinFn(new JoinFn(new MapGetter(),new KeySetGetter()),new ContainsAllChecker(["sex","age","userId","address","comment","hobby","name"])),new FixFn(true),new MessageValidator("validator.acceptable")),new NameBranchIfExists(new BooleanStateAndFactory(),{"userId":new IfFn(new TryFn(new ConvertValidator(new JoinFn(new JoinFn(new ToStringConverter(),new ParseConverter(new CloneFormatFactory(new DecimalFormat("#,##0.###")))),new ToIntegerConverter())),new FixFn(false),new FixFn(true)),new FixFn(true),new MessageValidator("validator.userId.parse")),"name":new IfFn(new JoinFn(new JoinFn(new ValueGetter(),new ToStringConverter()),new MaxLengthChecker(40)),new FixFn(true),new MessageValidator("validator.name.maxLength")),"sex":new BoolSeq(new BooleanStateAndAndFactory(),[new IfFn(new JoinFn(new ValueGetter(),new ContainsChecker(["0","1"])),new FixFn(true),new MessageValidator("validator.sex.acceptable")),new IfFn(new TryFn(new ConvertValidator(new JoinFn(new JoinFn(new ToStringConverter(),new ParseConverter(new CloneFormatFactory(new DecimalFormat("#,##0.###")))),new ToIntegerConverter())),new FixFn(false),new FixFn(true)),new FixFn(true),new MessageValidator("validator.sex.parse"))]),"address":new IfFn(new JoinFn(new JoinFn(new ValueGetter(),new ToStringConverter()),new MaxLengthChecker(80)),new FixFn(true),new MessageValidator("validator.address.maxLength")),"age":new BoolSeq(new BooleanStateAndAndFactory(),[new IfFn(new TryFn(new ConvertValidator(new JoinFn(new JoinFn(new ToStringConverter(),new ParseConverter(new CloneFormatFactory(new DecimalFormat("#,##0.###")))),new ToIntegerConverter())),new FixFn(false),new FixFn(true)),new FixFn(true),new MessageValidator("validator.age.parse")),new IfFn(new JoinFn(new JoinFn(new ValueGetter(),new CastFn(null)),new MinChecker(0)),new FixFn(true),new MessageValidator("validator.age.min")),new IfFn(new JoinFn(new JoinFn(new ValueGetter(),new CastFn(null)),new MaxChecker(200)),new FixFn(true),new MessageValidator("validator.age.max"))]),"hobby":new IfFn(new JoinFn(new ValuesGetter(),new ContainsAllChecker(["0","1","2","3"])),new FixFn(true),new MessageValidator("validator.hobby.acceptable")),"comment":new IfFn(new JoinFn(new JoinFn(new ValueGetter(),new ToStringConverter()),new MaxLengthChecker(200)),new FixFn(true),new MessageValidator("validator.comment.maxLength"))}),new IfFn(new JoinFn(new IdGetter(),new RegExpChecker(new RegExp("user_(deleteConfirm|updateInput)","g"))),new NameBranch(new BooleanStateAndFactory(),{"userId":new IfFn(new JoinFn(new ValueGetter(),new NotEmptyChecker()),new FixFn(true),new MessageValidator("validator.userId.required"))}),new FixFn(true)),new IfFn(new JoinFn(new IdGetter(),new RegExpChecker(new RegExp("user_(register|update)(Confirm|Result)","g"))),new NameBranch(new BooleanStateAndFactory(),{"name":new IfFn(new JoinFn(new ValueGetter(),new NotEmptyChecker()),new FixFn(true),new MessageValidator("validator.name.required")),"sex":new IfFn(new JoinFn(new ValueGetter(),new NotEmptyChecker()),new FixFn(true),new MessageValidator("validator.sex.required")),"address":new IfFn(new JoinFn(new ValueGetter(),new NotEmptyChecker()),new FixFn(true),new MessageValidator("validator.address.required")),"age":new IfFn(new JoinFn(new ValueGetter(),new NotEmptyChecker()),new FixFn(true),new MessageValidator("validator.age.required"))}),new FixFn(true))])
;