/*
 * Decompiled with CFR 0.152.
 */
package woolpack.acquirable;

import woolpack.acquirable.Acquirable;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquireFn<C, R, E extends Exception>
implements Fn<C, R, E> {
    private Fn<? super C, ? extends Acquirable<? extends E>, ? extends E> acquireGetter;
    private Fn<? super C, ? extends R, ? extends E> trueFn;
    private Fn<? super C, ? extends R, ? extends E> falseFn;

    public AcquireFn(Fn<? super C, ? extends Acquirable<? extends E>, ? extends E> acquireGetter, Fn<? super C, ? extends R, ? extends E> trueFn, Fn<? super C, ? extends R, ? extends E> falseFn) {
        this.acquireGetter = acquireGetter;
        this.trueFn = trueFn;
        this.falseFn = falseFn;
    }

    @Override
    public R exec(C c) throws E {
        Acquirable<E> acquirable = this.acquireGetter.exec(c);
        if (acquirable != null) {
            if (acquirable.acquire()) {
                try {
                    R r = this.trueFn.exec(c);
                    return r;
                }
                finally {
                    acquirable.release();
                }
            }
            return this.falseFn.exec(c);
        }
        return this.trueFn.exec(c);
    }

    public Fn<? super C, ? extends R, ? extends E> getFalseFn() {
        return this.falseFn;
    }

    public void setFalseFn(Fn<? super C, ? extends R, ? extends E> falseFn) {
        this.falseFn = falseFn;
    }

    public Fn<? super C, ? extends Acquirable<? extends E>, ? extends E> getAcquireGetter() {
        return this.acquireGetter;
    }

    public void setAcquireGetter(Fn<? super C, ? extends Acquirable<? extends E>, ? extends E> acquireGetter) {
        this.acquireGetter = acquireGetter;
    }

    public Fn<? super C, ? extends R, ? extends E> getTrueFn() {
        return this.trueFn;
    }

    public void setTrueFn(Fn<? super C, ? extends R, ? extends E> trueFn) {
        this.trueFn = trueFn;
    }
}

