/*
 * Decompiled with CFR 0.152.
 */
package woolpack.idweb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import woolpack.el.EL;
import woolpack.fn.Fn;
import woolpack.id.IdContext;
import woolpack.validator.AddressedMessage;
import woolpack.validator.AddressedMessageCollector;
import woolpack.validator.ValidatorContext;
import woolpack.web.WebContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFn<C extends WebContext & IdContext, E extends Exception>
implements Fn<C, Void, E> {
    private Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn;
    private Fn<? super C, Void, ? extends E> trueFn;
    private Fn<? super C, Void, ? extends E> falseFn;
    private Fn<? super List<AddressedMessage>, ?, ? extends E> messageListConverter;
    private EL messageListSetter;
    private boolean convertDelegateFlag;
    private boolean convertReturnFlag;

    public ValidatorFn(Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn, Fn<? super C, Void, ? extends E> trueFn, Fn<? super C, Void, ? extends E> falseFn, Fn<? super List<AddressedMessage>, ?, ? extends E> messageListConverter, EL messageListSetter, boolean convertDelegateFlag, boolean convertReturnFlag) {
        this.validatorFn = validatorFn;
        this.trueFn = trueFn;
        this.falseFn = falseFn;
        this.messageListConverter = messageListConverter;
        this.messageListSetter = messageListSetter;
        this.convertDelegateFlag = convertDelegateFlag;
        this.convertReturnFlag = convertReturnFlag;
    }

    @Override
    public Void exec(C c) throws E {
        ValidatorContext validatorContext = new ValidatorContext();
        AddressedMessageCollector collector = new AddressedMessageCollector();
        validatorContext.setCollectable(collector);
        validatorContext.setId(c.getId());
        Map<String, List<Object>> beforeMap = c.getInput();
        HashMap<String, List<Object>> afterMap = new HashMap<String, List<Object>>();
        for (Map.Entry<String, List<Object>> entry : beforeMap.entrySet()) {
            afterMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        validatorContext.setInputMap(afterMap);
        try {
            boolean result = this.validatorFn.exec(validatorContext);
            c.setInput(this.convertDelegateFlag ? afterMap : beforeMap);
            if (result) {
                this.trueFn.exec(c);
            } else {
                this.messageListSetter.setValue(c, this.messageListConverter.exec(collector.getList()));
                this.falseFn.exec(c);
            }
        }
        catch (Throwable throwable) {
            c.setInput(this.convertReturnFlag ? afterMap : beforeMap);
            throw throwable;
        }
        c.setInput(this.convertReturnFlag ? afterMap : beforeMap);
        return null;
    }

    public boolean isConvertDelegateFlag() {
        return this.convertDelegateFlag;
    }

    public void setConvertDelegateFlag(boolean convertDelegateFlag) {
        this.convertDelegateFlag = convertDelegateFlag;
    }

    public boolean isConvertReturnFlag() {
        return this.convertReturnFlag;
    }

    public void setConvertReturnFlag(boolean convertReturnFlag) {
        this.convertReturnFlag = convertReturnFlag;
    }

    public Fn<? super C, Void, ? extends E> getFalseFn() {
        return this.falseFn;
    }

    public void setFalseFn(Fn<? super C, Void, ? extends E> falseFn) {
        this.falseFn = falseFn;
    }

    public Fn<? super List<AddressedMessage>, ?, ? extends E> getMessageListConverter() {
        return this.messageListConverter;
    }

    public void setMessageListConverter(Fn<? super List<AddressedMessage>, ?, ? extends E> messageListConverter) {
        this.messageListConverter = messageListConverter;
    }

    public EL getMessageListSetter() {
        return this.messageListSetter;
    }

    public void setMessageListSetter(EL messageListSetter) {
        this.messageListSetter = messageListSetter;
    }

    public Fn<? super C, Void, ? extends E> getTrueFn() {
        return this.trueFn;
    }

    public void setTrueFn(Fn<? super C, Void, ? extends E> trueFn) {
        this.trueFn = trueFn;
    }

    public Fn<? super ValidatorContext, Boolean, ? extends E> getValidatorFn() {
        return this.validatorFn;
    }

    public void setValidatorFn(Fn<? super ValidatorContext, Boolean, ? extends E> validatorFn) {
        this.validatorFn = validatorFn;
    }
}

