/*
 * Decompiled with CFR 0.152.
 */
package woolpack.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.fn.Fn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeFindUtils {
    private NodeFindUtils() {
    }

    public static <E extends Exception> Fn<Node, Node, E> one(final Fn<Node, Boolean, ? extends E> nodeChecker) {
        return new Fn<Node, Node, E>(){

            @Override
            public Node exec(Node c) throws Exception {
                if (((Boolean)nodeChecker.exec(c)).booleanValue()) {
                    return c;
                }
                NodeList nodeList = c.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node result = this.exec(nodeList.item(i));
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
                return null;
            }
        };
    }

    public static <E extends Exception> Fn<Node, NodeList, E> list(final Fn<Node, Boolean, ? extends E> nodeChecker, final boolean deepFlag) {
        return new Fn<Node, NodeList, E>(){

            @Override
            public NodeList exec(Node c) throws Exception {
                final ArrayList<Node> list = new ArrayList<Node>();
                this.findNode(list, c);
                return new NodeList(){

                    public int getLength() {
                        return list.size();
                    }

                    public Node item(int i) {
                        return (Node)list.get(i);
                    }
                };
            }

            private void findNode(List<Node> list, Node base) throws Exception {
                if (((Boolean)nodeChecker.exec(base)).booleanValue()) {
                    list.add(base);
                    if (!deepFlag) {
                        return;
                    }
                }
                NodeList nodeList = base.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    this.findNode(list, nodeList.item(i));
                    ++i;
                }
            }
        };
    }
}

