"""
Copyright (c) 2006, www.everes.net
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the everes nor the names of its contributors may be 
      used to endorse or promote products derived from this software without 
      specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF 
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""
from django.core import meta
from WorkStyle.settings import WORKSTYLE_JUNK_DIR, TAG_TYPE_1, TAG_TYPE_2, TAG_TYPE_3, TAG_TYPE_4, TAG_TYPE_5, TAG_TYPE_6, TAG_TYPE_7, TAG_TYPE_8, TAG_TYPE_9, TAG_TYPE_10

# Create your models here.
TASK_STATUS = (
    (1, _('EXECUTING'),'on_going'),
    (2, _('ASAP'),'rapid'),
    (3, _('LATER'),'normal'),
    (4, _('PENDING'),'review'),
    (5, _('APPROVING'),'pending'),
    (6, _('DONE'),'finish'),
)

TASK_STATUS_CHOICES = (
    (1, _('EXECUTING')),
    (2, _('ASAP')),
    (3, _('LATER')),
    (4, _('PENDING')),
    (5, _('APPROVING')),
    (6, _('DONE')),
)

TAG_TYPE_CHOICES = (
    (1, TAG_TYPE_1),
    (2, TAG_TYPE_2),
    (3, TAG_TYPE_3),
    (4, TAG_TYPE_4),
    (5, TAG_TYPE_5),
    (6, TAG_TYPE_6),
    (7, TAG_TYPE_7),
    (8, TAG_TYPE_8),
    (9, TAG_TYPE_9),
    (10, TAG_TYPE_10),
)

class Task(meta.Model):
    task = meta.TextField(db_index=True)
    create_date = meta.DateTimeField(auto_now_add=True)
    update_date = meta.DateTimeField()
    tag_searchable = meta.CharField(maxlength=800, db_index=True, null=True)
    estimate = meta.FloatField(max_digits=3, default=0, decimal_places=1, null=True)
    status = meta.IntegerField(maxlength=1, default=3, choices=TASK_STATUS_CHOICES, db_index=True)
    class META:
        ordering = ['-update_date']

class Tag(meta.Model):
    name = meta.CharField(maxlength=50)
    tag_type = meta.IntegerField(maxlength=2, default=1, choices=TAG_TYPE_CHOICES)
    visible = meta.BooleanField(default=True)
    class META:
        ordering = ['id']
    def __repr__(self):
        return self.name
    class META:
        ordering = ['tag_type', 'id']


class TagList(meta.Model):
    task = meta.ForeignKey(Task)
    tag  = meta.ForeignKey(Tag)

class Comment(meta.Model):
    comment    = meta.TextField()
    create_date = meta.DateTimeField(auto_now_add=True)
    commentator = meta.CharField(maxlength=50, null=True)
    task        = meta.ForeignKey(Task)


class Attachment(meta.Model):
    create_date = meta.DateTimeField(auto_now_add=True)
    name        = meta.CharField(maxlength=200)
    file        = meta.FileField(upload_to=WORKSTYLE_JUNK_DIR)
    size        = meta.IntegerField(maxlength=12)
    task        = meta.ForeignKey(Task)


