<?php
/* ==================================================
 *   Lat_Long Class
   ================================================== */

define('GEO_META_FIELD_NAME', 'Lat_Long');

class Lat_Long {

// ==================================================
function get_LatLon() {
	global $post;
	$latlongs = array();
	$meta_values = get_post_meta($post->ID, GEO_META_FIELD_NAME);
	if (! $meta_values) {
		return NULL;
	}
	foreach ($meta_values as $lat_long) {
		list($lat, $lon) = array_map('floatval', split(',', $lat_long));
		$latlongs[] = compact('lat', 'lon');
	}
	return $latlongs;
}

// ==================================================
function is_same($point1, $point2) {
	return (abs($point1['lat'] - $point2['lat']) < 0.0000000001 && abs($point1['lon'] - $point2['lon']) < 0.0000000001);
}

// ==================================================
function posts_in_bounds($bounds) {
	if (count($bounds) != 4 || abs($bounds[0] - $bounds[2]) >= 1.0 || abs($bounds[1] - $bounds[3]) >= 1.0 ) {
		return NULL;
	}
	$center = array('lat' => ($bounds[0] + $bounds[2]) / 2, 'lon' => ($bounds[1] + $bounds[3]) / 2);
	$south_lat = min($bounds[0], $bounds[2]);
	$north_lat = max($bounds[0], $bounds[2]);
	$west_lon  = min($bounds[1], $bounds[3]);
	$east_lon  = max($bounds[1], $bounds[3]);
	global $wpdb;
	$locations = $wpdb->get_results("SELECT post_id,meta_value FROM {$wpdb->postmeta} WHERE meta_key = '" . GEO_META_FIELD_NAME . "' AND SUBSTRING_INDEX(meta_value, ',',1) >= $south_lat AND SUBSTRING_INDEX(meta_value, ',',1) <= $north_lat AND SUBSTRING_INDEX(meta_value, ',',-1) >= $west_lon AND SUBSTRING_INDEX(meta_value, ',',-1) <= $east_lon ORDER BY post_id DESC");
	$posts_w_loc = array();
	foreach ($locations as $l) {
		list($lat, $lon) = array_map('floatval', split(',', $l->meta_value));
		$posts_w_loc[$l->post_id][] = compact('lat', 'lon');
	}
	return $posts_w_loc;
}

// ===== End of class ==========
}
?>