<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS.

   ***** DO NOT EDIT THIS FILE WITH WORDPRESS ADMIN PANEL *****
*/

/* ==================================================
 *   Ktai_Service_imode class
   ================================================== */

class Ktai_Service_imode extends Ktai_Services {
	// http://www.nttdocomo.co.jp/service/imode/make/content/ip/
	// Last Update: 2006-10-23
	static public $networks = array(
		'210.153.84.0/24',
		'210.136.161.0/24',
		'210.153.86.0/24',
	);
	// http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/
	static public $pics = array(
		'd001' => "\xf8\x9f", // 
		'd002' => "\xf8\xa0", // ܂
		'd003' => "\xf8\xa1", // J
		'd004' => "\xf8\xa2", //  
		'd005' => "\xf8\xa3", // 
		'd006' => "\xf8\xa4", // 䕗
		'd007' => "\xf8\xa5", // 
		'd008' => "\xf8\xa6", // J
		'd009' => "\xf8\xa7", // r
		'd010' => "\xf8\xa8", // 
		'd011' => "\xf8\xa9", // oq
		'd012' => "\xf8\xaa", // I
		'd013' => "\xf8\xab", // q
		'd014' => "\xf8\xac", // 
		'd015' => "\xf8\xad", // V
		'd016' => "\xf8\xae", // 嶍
		'd017' => "\xf8\xaf", // ˎ
		'd018' => "\xf8\xb0", // Rr
		'd019' => "\xf8\xb1", // r
		'd020' => "\xf8\xb2", // 
		'd021' => "\xf8\xb3", // X|[c
		'd022' => "\xf8\xb4", // 싅
		'd023' => "\xf8\xb5", // St
		'd024' => "\xf8\xb6", // ejX
		'd025' => "\xf8\xb7", // TbJ[
		'd026' => "\xf8\xb8", // XL[
		'd027' => "\xf8\xb9", // oXPbg{[
		'd028' => "\xf8\xba", // [^[X|[c (`FbJ[tbO)
		'd029' => "\xf8\xbb", // |Pbgx
		'd030' => "\xf8\xbc", // d
		'd031' => "\xf8\xbd", // nS
		'd032' => "\xf8\xbe", // V
		'd033' => "\xf8\xbf", //  (Z_)
		'd034' => "\xf8\xc0", //  (RV)
		'd035' => "\xf8\xc1", // oX
		'd036' => "\xf8\xc2", // D
		'd037' => "\xf8\xc3", // s@
		'd038' => "\xf8\xc4", // 
		'd039' => "\xf8\xc5", // r
		'd040' => "\xf8\xc6", // X֋
		'd041' => "\xf8\xc7", // a@
		'd042' => "\xf8\xc8", // s
		'd043' => "\xf8\xc9", // ATM
		'd044' => "\xf8\xca", // ze
		'd045' => "\xf8\xcb", // Rrj
		'd046' => "\xf8\xcc", // K\X^h
		'd047' => "\xf8\xcd", // ԏ
		'd048' => "\xf8\xce", // M
		'd049' => "\xf8\xcf", // gC
		'd050' => "\xf8\xd0", // Xg
		'd051' => "\xf8\xd1", // iX
		'd052' => "\xf8\xd2", // o[ (}eB[j)
		'd053' => "\xf8\xd3", // r[
		'd054' => "\xf8\xd4", // t@[Xgt[h (no[K[)
		'd055' => "\xf8\xd5", // ueBbN
		'd056' => "\xf8\xd6", // e@ ()
		'd057' => "\xf8\xd7", // JIP
		'd058' => "\xf8\xd8", // f
		'd059' => "\xf8\xd9", // E΂ߏ
		'd060' => "\xf8\xda", // Vn (ؔn)
		'd061' => "\xf8\xdb", // y (wbhz)
		'd062' => "\xf8\xdc", // A[g
		'd063' => "\xf8\xdd", // 
		'd064' => "\xf8\xde", // Cxg (T[JX)
		'd065' => "\xf8\xdf", // `Pbg
		'd066' => "\xf8\xe0", // i
		'd067' => "\xf8\xe1", // ։
		'd068' => "\xf8\xe2", // J
		'd069' => "\xf8\xe3", // Jo
		'd070' => "\xf8\xe4", // {
		'd071' => "\xf8\xe5", // {
		'd072' => "\xf8\xe6", // v[g
		'd073' => "\xf8\xe7", // o[Xf[
		'd074' => "\xf8\xe8", // db
		'd075' => "\xf8\xe9", // gѓdb
		'd076' => "\xf8\xea", // 
		'd077' => "\xf8\xeb", // TV
		'd078' => "\xf8\xec", // Q[
		'd079' => "\xf8\xed", // CD
		'd080' => "\xf8\xee", // n[g
		'd081' => "\xf8\xef", // Xy[h
		'd082' => "\xf8\xf0", // _C
		'd083' => "\xf8\xf1", // Nu
		'd084' => "\xf8\xf2", // 
		'd085' => "\xf8\xf3", // 
		'd086' => "\xf8\xf4", //  (O[)
		'd087' => "\xf8\xf5", //  (`L)
		'd088' => "\xf8\xf6", //  (p[)
		'd089' => "\xf8\xf7", // E΂߉
		'd090' => "\xf8\xf8", // ΂ߏ
		'd091' => "\xf8\xf9", // 
		'd092' => "\xf8\xfa", // 
		'd093' => "\xf8\xfb", // ዾ
		'd094' => "\xf8\xfc", // Ԉ֎q
		'd095' => "\xf9\x40", // V
		'd096' => "\xf9\x41", // ⌇
		'd097' => "\xf9\x42", // 
		'd098' => "\xf9\x43", // O
		'd099' => "\xf9\x44", // 
		'd100' => "\xf9\x45", // 
		'd101' => "\xf9\x46", // L
		'd102' => "\xf9\x47", // ][g (bg)
		'd103' => "\xf9\x48", // NX}X
		'd104' => "\xf9\x49", // ΂߉
		'd105' => "\xf9\x72", // phone to
		'd106' => "\xf9\x73", // mail to
		'd107' => "\xf9\x74", // fax to
		'd108' => "\xf9\x75", // i[h
		'd109' => "\xf9\x76", // i[h (gt)
		'd110' => "\xf9\x77", // [
		'd111' => "\xf9\x78", // hR
		'd112' => "\xf9\x79", // hR|Cg
		'd113' => "\xf9\x7a", // L
		'd114' => "\xf9\x7b", // 
		'd115' => "\xf9\x7c", // ID
		'd116' => "\xf9\x7d", // pX[h
		'd117' => "\xf9\x7e", // L
		'd118' => "\xf9\x80", // NA
		'd119' => "\xf9\x81", // T[` (ׂ)
		'd120' => "\xf9\x82", // NEW
		'd121' => "\xf9\x83", // ʒu
		'd122' => "\xf9\x84", // t[_C
		'd123' => "\xf9\x85", // V[v_C
		'd124' => "\xf9\x86", // oQ
		'd125' => "\xf9\x87", // 1 (one)
		'd126' => "\xf9\x88", // 2 (two)
		'd127' => "\xf9\x89", // 3 (three)
		'd128' => "\xf9\x8a", // 4 (four)
		'd129' => "\xf9\x8b", // 5 (five)
		'd130' => "\xf9\x8c", // 6 (six)
		'd131' => "\xf9\x8d", // 7 (seven)
		'd132' => "\xf9\x8e", // 8 (eight)
		'd133' => "\xf9\x8f", // 9 (nine)
		'd134' => "\xf9\x90", // 0 (zero)
		'd135' => "\xf9\xb0", //  (OK)
		'd136' => "\xf9\x91", // n[g
		'd137' => "\xf9\x92", // hn[g
		'd138' => "\xf9\x93", // 
		'd139' => "\xf9\x94", // n[g (n[g)
		'd140' => "\xf9\x95", // [ ()
		'd141' => "\xf9\x96", //  ({)
		'd142' => "\xf9\x97", // ` (_)
		'd143' => "\xf9\x98", // ₾` (߂)
		'd144' => "\xf9\x99", // ӂӂ
		'd145' => "\xf9\x9a", // Obh ()
		'd146' => "\xf9\x9b", //  ()
		'd147' => "\xf9\x9c", // C ()
		'd148' => "\xf9\x9d", // 킢
		'd149' => "\xf9\x9e", // LX}[N
		'd150' => "\xf9\x9f", // ҂҂ (V)
		'd151' => "\xf9\xa0", // Ђ߂
		'd152' => "\xf9\xa1", // ނ ({)
		'd153' => "\xf9\xa2", // p`
		'd154' => "\xf9\xa3", // e
		'd155' => "\xf9\xa4", // [h
		'd156' => "\xf9\xa5", // obh ()
		'd157' => "\xf9\xa6", //  ()
		'd158' => "\xf9\xa7", // exclamation
		'd159' => "\xf9\xa8", // exclamation and question
		'd160' => "\xf9\xa9", // double exclamation
		'd161' => "\xf9\xaa", // ǂ (Ռ)
		'd162' => "\xf9\xab", //  (юU銾)
		'd163' => "\xf9\xac", // [ ()
		'd164' => "\xf9\xad", // _bV (o)
		'd165' => "\xf9\xae", // [ (L1)
		'd166' => "\xf9\xaf", // [ (L2)
		'd167' => "\xf9\x50", // J`R
		'd168' => "\xf9\x51", // ӂ
		'd169' => "\xf9\x52", // y
		'd170' => "\xf9\x55", // le
		'd171' => "\xf9\x56", // 
		'd172' => "\xf9\x57", // 
		'd173' => "\xf9\x5b", // soon
		'd174' => "\xf9\x5c", // on
		'd175' => "\xf9\x5d", // end
		'd176' => "\xf9\x5e", // v
		'd201' => "\xf9\xb1", // iAv
		'd202' => "\xf9\xb2", // iAv (gt)
		'd203' => "\xf9\xb3", // TVc ({[_[)
		'd204' => "\xf9\xb4", // ܌z
		'd205' => "\xf9\xb5", // 
		'd206' => "\xf9\xb6", // W[Y
		'd207' => "\xf9\xb7", // Xm{
		'd208' => "\xf9\xb8", // `y
		'd209' => "\xf9\xb9", // hA
		'd210' => "\xf9\xba", // h
		'd211' => "\xf9\xbb", // p\R
		'd212' => "\xf9\xbc", // u^[
		'd213' => "\xf9\xbd", // `
		'd214' => "\xf9\xbe", // M
		'd215' => "\xf9\xbf", // 
		'd216' => "\xf9\xc0", // w
		'd217' => "\xf9\xc1", // v
		'd218' => "\xf9\xc2", // ]
		'd219' => "\xf9\xc3", // ̂
		'd220' => "\xf9\xc4", // rv
		'd221' => "\xf9\xc5", // lĂ
		'd222' => "\xf9\xc6", // قƂ
		'd223' => "\xf9\xc7", // ⊾ ()
		'd224' => "\xf9\xc8", // ⊾2 ()
		'd225' => "\xf9\xc9", // ՂȊ
		'd226' => "\xf9\xca", // {P[Ƃ
		'd227' => "\xf9\xcb", // ڂn[g ()
		'd228' => "\xf9\xcc", // wOK
		'd229' => "\xf9\xcd", // ׁ[
		'd230' => "\xf9\xce", // EBN
		'd231' => "\xf9\xcf", // ꂵ
		'd232' => "\xf9\xd0", // ܂
		'd233' => "\xf9\xd1", // L2
		'd234' => "\xf9\xd2", // 
		'd235' => "\xf9\xd3", // 
		'd236' => "\xf9\xd4", // NG
		'd237' => "\xf9\xd5", // Nbv
		'd238' => "\xf9\xd6", // Rs[Cg (C)
		'd239' => "\xf9\xd7", // g[h}[N (TM)
		'd240' => "\xf9\xd8", // l
		'd241' => "\xf9\xd9", // }
		'd242' => "\xf9\xda", // TCN
		'd243' => "\xf9\xdb", // WX^[hg[h}[N (R)
		'd244' => "\xf9\xdc", // 댯Ex (!)
		'd245' => "\xf9\xdd", // ֎~
		'd246' => "\xf9\xde", // 󎺁EȁE
		'd247' => "\xf9\xdf", // i}[N
		'd248' => "\xf9\xe0", // EȁE
		'd249' => "\xf9\xe1", // 󍶉E
		'd250' => "\xf9\xe2", // ㉺
		'd251' => "\xf9\xe3", // wZ
		'd252' => "\xf9\xe4", // g
		'd253' => "\xf9\xe5", // xmR
		'd254' => "\xf9\xe6", // N[o[
		'd255' => "\xf9\xe7", // 
		'd256' => "\xf9\xe8", // `[bv
		'd257' => "\xf9\xe9", // oii
		'd258' => "\xf9\xea", // 
		'd259' => "\xf9\xeb", // 
		'd260' => "\xf9\xec", // ݂
		'd261' => "\xf9\xed", // 
		'd262' => "\xf9\xee", // ɂ
		'd263' => "\xf9\xef", // V[gP[L
		'd264' => "\xf9\xf0", // Ƃ (傱t)
		'd265' => "\xf9\xf1", // ǂԂ
		'd266' => "\xf9\xf2", // p
		'd267' => "\xf9\xf3", // ނ
		'd268' => "\xf9\xf4", // Ђ悱
		'd269' => "\xf9\xf5", // yM
		'd270' => "\xf9\xf6", // 
		'd271' => "\xf9\xf7", // ܂! ()
		'd272' => "\xf9\xf8", // EbVbV ()
		'd273' => "\xf9\xf9", // E}
		'd274' => "\xf9\xfa", // u^
		'd275' => "\xf9\xfb", // COX
		'd276' => "\xf9\xfc", //  ()
	);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	$this->operator   = 'DoCoMo';
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	$this->require_id_msg = __("ERROR: Please send your mobile phone info, or configure to notify your i-mode ID.\nGo iMenu &gt; Charges &amp;Apply/Prefs &gt; 4.Options &gt; i-mode ID notify preference.", 'ktai_style');
	// http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/basic/
	return;
}


/* ==================================================
 * @param	none
 * @return	boolean $in_network
 */
public function in_network() {
	return parent::in_network(self::$networks);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = apply_filters('smiley_table/ktai_style.php', array(
		'icon_smile.gif'     => self::$pics['d140'],
		'icon_biggrin.gif'   => self::$pics['d231'],
		'icon_sad.gif'       => self::$pics['d143'],
		'icon_surprised.gif' => self::$pics['d276'],
		'icon_eek.gif'       => self::$pics['d276'],
		'icon_confused.gif'  => self::$pics['d221'],
		'icon_cool.gif'      => self::$pics['d271'],
		'icon_mad.gif'       => self::$pics['d141'],
		'icon_razz.gif'      => self::$pics['d229'],
		'icon_neutral.gif'   => self::$pics['d226'],
		'icon_wink.gif'      => self::$pics['d230'],
		'icon_lol.gif'       => self::$pics['d229'],
		'icon_redface.gif'   => self::$pics['d227'],
		'icon_cry.gif'       => self::$pics['d234'],
		'icon_evil.gif'      => self::$pics['d225'],
		'icon_twisted.gif'   => self::$pics['d225'],
		'icon_rolleyes.gif'  => self::$pics['d221'],
		'icon_exclaim.gif'   => self::$pics['d244'],
		'icon_question.gif'  => '(?)',
		'icon_idea.gif'      => self::$pics['d151'],
		'icon_arrow.gif'     => self::$pics['d173'],
		'icon_mrgreen.gif'   => self::$pics['d272'],
	));
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_pict($buffer) {
	// http://www.au.kddi.com/email/emoji/
	// http://mb.softbank.jp/mb/service/3G/mail/pictogram/
	// http://www.nttdocomo.co.jp/service/mail/imode_mail/emoji_convert/
	// http://www.willcom-inc.com/ja/service/e_mail/pdf/conversiontable.pdf
	$trans = apply_filters('pictogram_table/ktai_style.php', self::$pics + array(
		'1'     => self::$pics['d244'], // u!v
		'2'     => '!',                 // u!v
		'3'     => '?',                 // u?v
		'4'     => self::$pics['d124'], // uQv
		'5'     => '',                // Op1
		'6'     => '',                // EOp1
		'7'     => '',                // Op2
		'8'     => '',                // EOp2
		'9'     => '',                // lp 1
		'10'    => '',                // lp 2
		'11'    => '[i]',               // CtH[VV{
		'12'    => self::$pics['d275'], // COX
		'13'    => '[Xs[J[]',      // Xs[J[
		'14'    => '$',                 // h}[N
		'15'    => self::$pics['d098'], //  1
		'16'    => self::$pics['d005'], // Ȃ
		'17'    => '',                // lp 1
		'18'    => '',                // lp 2
		'19'    => '',                // H` 1
		'20'    => '',                // H` 2
		'21'    => '',                // lp 1
		'22'    => '',                // lp 2
		'23'    => '',                // H` 1
		'24'    => '',                // H` 2
		'25'    => self::$pics['d220'], // rv
		'26'    => '+',                 // vX
		'27'    => '-',                 // }CiX
		'28'    => '',                //  1
		'29'    => '',                //  1
		'30'    => '',                //  1
		'31'    => self::$pics['d245'], // ۂɎ΂ߐ
		'32'    => '',                // Op 1
		'33'    => '',                // Op 1
		'34'    => '',                // Op 2
		'35'    => '',                // Op 2
		'36'    => '',                // H` 1
		'37'    => '',                // H` 2
		'38'    => '',                // lp 1
		'39'    => '',                // lp 2
		'40'    => '',                //  1
		'41'    => '',                //  2
		'42'    => self::$pics['d090'], //  2 ()
		'43'    => self::$pics['d089'], //  2 (E)
		'44'    => self::$pics['d001'], // z
		'45'    => self::$pics['d022'], // 싅{[
		'46'    => self::$pics['d176'], // v
		'47'    => self::$pics['d097'], //  2 ()
		'48'    => self::$pics['d097'], // x
		'49'    => '[e]',            // vbVs (e)
		'50'    => self::$pics['d170'], // 
		'51'    => self::$pics['d136'], // n[g
		'52'    => self::$pics['d052'], // }eB[j (JNeOX)
		'53'    => self::$pics['d254'], // lt
		'54'    => self::$pics['d239'], // g[h}[N (TM)
		'55'    => '~',                // 
		'56'    => self::$pics['d076'], //  1
		'57'    => self::$pics['d217'], // v 1
		'58'    => self::$pics['d217'], // v 2
		'59'    => '[tbs[]',      // tbs[fBXN 1
		'60'    => '*',                 // ̌
		'61'    => '~',                // oc 1
		'62'    => '~',                // oc 2
		'63'    => '',                // E 1
		'64'    => '',                //  1
		'65'    => self::$pics['d051'], // }OJbv
		'66'    => '',                // 
		'67'    => '[J_[]',      // J_[
		'68'    => self::$pics['d140'], // X}CtFCX
		'69'    => '',                //  2
		'70'    => self::$pics['d059'], // E 2 (E)
		'71'    => self::$pics['d104'], //  2 ()
		'72'    => self::$pics['d216'], // WG[
		'73'    => '',                // `FbN}[N 1
		'74'    => self::$pics['d100'],  //  (v[h)
		'75'    => '',                //  3
		'76'    => self::$pics['d150'], // Xp[N
		'77'    => self::$pics['d151'], // d
		'78'    => self::$pics['d268'], // 
		'79'    => '[tH_]',        // tH_ 1 ()
		'80'    => self::$pics['d140'], //  1
		'81'    => self::$pics['d238'], // Rs[Cg}[N (C)
		'82'    => self::$pics['d243'], // WX^[h}[N (R)
		'83'    => self::$pics['d069'], // u[tP[X (nhobN)
		'84'    => '[tH_]',        // tH_ 2 (J)
		'85'    => self::$pics['d074'], // db 1 (vbVz)
		'86'    => self::$pics['d076'], // oRg
		'87'    => '[NWbgJ[h]',// NWbgJ[h
		'88'    => '',                // Op 3
		'89'    => '',                // Op 3
		'90'    => '[USA]',             // USA ()
		'91'    => self::$pics['d076'], // m[g 3
		'92'    => self::$pics['d076'], // Nbv{[h
		'93'    => self::$pics['d051'], // Jbv
		'94'    => self::$pics['d068'], // J
		'95'    => self::$pics['d003'], // J
		'96'    => '[tbg{[]',    // tbg{[
		'97'    => self::$pics['d070'], // { 1
		'98'    => self::$pics['d245'], // ֎~
		'99'    => self::$pics['d048'], // M
		'100'   => self::$pics['d070'],   // { 2
		'101'   => self::$pics['d070'],   // { 3
		'102'   => self::$pics['d070'],   // { 4
		'103'   => self::$pics['d076'],   //  2
		'104'   => self::$pics['d056'], // ͂
		'105'   => '[J_[]',      // Ђ߂J_[
		'106'   => self::$pics['d065'], // `PbgELbv
		'107'   => self::$pics['d002'], // 
		'108'   => self::$pics['d110'], // 
		'109'   => self::$pics['d113'], // ؎ (CHECK)
		'110'   => self::$pics['d058'], // rfIJ
		'111'   => self::$pics['d058'],  // nfBJ
		'112'   => self::$pics['d038'], // 
		'113'   => self::$pics['d256'], //  (`[bv)
		'114'   => '[iCt]',          // iCt
		'115'   => '[rfIe[v]',    // rfIe[v
		'116'   => self::$pics['d093'], // ߂
		'117'   => '',              //  1
		'118'   => self::$pics['d117'], //  2
		'119'   => self::$pics['d119'], // ނ߂
		'120'   => self::$pics['d116'], // 
		'121'   => self::$pics['d076'],   // m[g 1
		'122'   => self::$pics['d076'],   // m[g 2 (J)
		'123'   => '[{gƃibg]',  // {g & ibg
		'124'   => self::$pics['d055'], //  (nCq[)
		'125'   => self::$pics['d033'], // 
		'126'   => '[tbs[]',      // tbs[ 2
		'127'   => '[_Ot]',        // `[g (_Ot)
		'128'   => '[܂Ot]',    // Ot 1 (܂Ot)
		'129'   => self::$pics['d110'],  // [{bNX
		'130'   => '[d]',        // d
		'131'   => '[Roldex]',          // Roldex
		'132'   => '',                // `FbN}[N 2
		'134'   => self::$pics['d100'], // 
		'135'   => '[dr]',            // dr
		'136'   => '[XN[]',      // XN[
		'137'   => '[e]',            // т傤
		'138'   => self::$pics['d116'], // O
		'139'   => self::$pics['d065'], // hD
		'140'   => '',                // wmF
		'141'   => '',                // wmFE
		'142'   => self::$pics['d070'], // 䒠
		'143'   => self::$pics['d237'], // Nbv
		'144'   => self::$pics['d072'], // v[g
		'145'   => '[D]',            // D
		'146'   => self::$pics['d050'], // Sn 1 (iCtƃtH[N)
		'147'   => self::$pics['d070'], // {
		'148'   => '[gbN]',        // gbN
		'149'   => self::$pics['d214'], // Gsc
		'150'   => '[IDO]',             // S (PDC)
		'151'   => self::$pics['d106'], //  2
		'152'   => self::$pics['d213'], // `
		'153'   => self::$pics['d110'] . "", // M BOX
		'154'   => self::$pics['d106'], // M BOX
		'155'   => self::$pics['d074'], // db 2 (b)
		'156'   => self::$pics['d039'], // HE
		'157'   => '',                // K 1 ()
		'158'   => '',                // K 2 (Op)
		'159'   => '[܂Ot]',    // Ot 2
		'160'   => self::$pics['d050'], // H 2 (}K)
		'161'   => self::$pics['d075'], // db 3 (g)
		'162'   => '[RZg]',      // RZg
		'163'   => self::$pics['d170'], // Ƒ
		'164'   => self::$pics['d071'], // N
		'165'   => self::$pics['d072'], // pbP[W
		'166'   => self::$pics['d107'], // FAX
		'167'   => self::$pics['d001'] . self::$pics['d002'], // Ƃǂ܂
		'168'   => self::$pics['d037'], // s@
		'169'   => self::$pics['d102'], // {[g (D)
		'170'   => '[TCR]',        // TCR
		'171'   => self::$pics['d076'], // V
		'172'   => self::$pics['d030'], // d
		'173'   => '@',                // SuN
		'174'   => ' ',                 // uN
		'175'   => ' ',                 // 41uN
		'176'   => self::$pics['d066'], // i
		'177'   => self::$pics['d067'], // ։
		'178'   => self::$pics['d094'], // Ԉ֎q
		'179'   => '[S]',          // t}[N
		'180'   => self::$pics['d125'], // lp 1
		'181'   => self::$pics['d126'], // lp 2
		'182'   => self::$pics['d127'], // lp 3
		'183'   => self::$pics['d128'], // lp 4
		'184'   => self::$pics['d129'], // lp 5
		'185'   => self::$pics['d130'], // lp 6
		'186'   => self::$pics['d131'], // lp 7
		'187'   => self::$pics['d132'], // lp 8
		'188'   => self::$pics['d133'], // lp 9
		'189'   => self::$pics['d134'], // lp 10
		'190'   => self::$pics['d006'], // 䕗
		'191'   => self::$pics['d004'], // 䂫
		'192'   => self::$pics['d009'], //  (Ђ)
		'193'   => self::$pics['d010'], //  ()
		'194'   => self::$pics['d011'], //  (oq)
		'195'   => self::$pics['d012'], //  (ɍ)
		'196'   => self::$pics['d013'], //  ()
		'197'   => self::$pics['d014'], //  (Ƃߍ)
		'198'   => self::$pics['d015'], //  (V)
		'199'   => self::$pics['d016'], //  ()
		'200'   => self::$pics['d017'], //  (č)
		'201'   => self::$pics['d018'], //  (€)
		'202'   => self::$pics['d019'], //  (r)
		'203'   => self::$pics['d020'], //  ()
		'204'   => '[֌]',          //  (ւт)
		'205'   => self::$pics['d043'], // ATM
		'206'   => self::$pics['d045'], // 24 HOURS (Rrj)
		'207'   => self::$pics['d049'], // gC
		'208'   => self::$pics['d047'], // p[LO
		'209'   => self::$pics['d035'], // oX
		'210'   => self::$pics['d121'], // Aei (ʒu}[N)
		'211'   => self::$pics['d036'], // ` (}[N)
		'212'   => self::$pics['d042'], // s
		'213'   => self::$pics['d046'], // KXX^h
		'214'   => '[n}]',            // n}
		'215'   => self::$pics['d218'], // ]
		'216'   => self::$pics['d035'], // oX
		'217'   => self::$pics['d032'], // V
		'218'   => self::$pics['d240'], // }\
		'219'   => self::$pics['d025'], // TbJ[
		'220'   => self::$pics['d024'], // ejX
		'221'   => self::$pics['d207'], // Xm[{[h
		'222'   => self::$pics['d028'], // `FbJ[tbO ([^[X|[c)
		'223'   => self::$pics['d060'], // Vn
		'224'   => self::$pics['d147'], // 
		'225'   => self::$pics['d264'], //  (Ԃ傤)
		'226'   => self::$pics['d167'], // f ()
		'227'   => self::$pics['d172'], // ̋
		'228'   => '[^[]',      // ^[
		'229'   => '[777]',             // Xbg (777)
		'230'   => '[]',          //  (A^̂)
		'231'   => '',              // I|
		'232'   => self::$pics['d078'], // Q[̃Rg[
		'233'   => self::$pics['d210'], // ܋
		'234'   => self::$pics['d103'], // NX}Xc[
		'235'   => self::$pics['d261'], // Ԍ ()
		'236'   => '[]',          // 
		'237'   => '[{]',            //  (jE̊)
		'238'   => '[Z]',            // XCJ
		'239'   => self::$pics['d263'], // P[L
		'240'   => '[tCp]',      // tCp (ڋʏĂ)
		'241'   => self::$pics['d255'], // 
		'242'   => '[͓]',            // ӂ
		'243'   => '[]',              // C`S
		'244'   => self::$pics['d262'], // ɂ
		'245'   => self::$pics['d054'], // no[K[ (t@[Xgt[h)
		'246'   => '[~]',              // 
		'247'   => '[e]',              // 
		'248'   => self::$pics['d273'], // 
		'249'   => '[]',              // 
		'250'   => '[^]',              // 
		'251'   => self::$pics['d101'], // L
		'252'   => self::$pics['d269'], // yM
		'253'   => '[a]',              // 
		'254'   => self::$pics['d274'], // Ԃ
		'255'   => '[q̖]',        // ₵̂
		'256'   => '[]',          // Ђ܂
		'257'   => self::$pics['d140'], //  1 (ꂵJI)
		'258'   => self::$pics['d141'], //  2 (JI)
		'259'   => self::$pics['d143'], //  3 (ȂJI)
		'260'   => self::$pics['d144'], //  4 (ꂽJI)
		'261'   => self::$pics['d157'], //  (ZZZ...)
		'262'   => self::$pics['d152'], // { (Jb)
		'263'   => self::$pics['d235'], //  (܁E)
		'264'   => self::$pics['d229'], // 炩 (ׂ)
		'265'   => self::$pics['d138'], // n[g 2 (Ă)
		'266'   => self::$pics['d139'], // n[g 3 (傫 & )
		'267'   => self::$pics['d150'], // Xp[N 2 (L}[N)
		'268'   => self::$pics['d154'], // e
		'269'   => '[]',              // 
		'270'   => '[SOS]',             // { (SOS)
		'271'   => '[͂]',          // ͂
		'272'   => '' . self::$pics['d136'], // n[g 5 (Ă)
		'273'   => self::$pics['d149'], // LX}[N
		'274'   => self::$pics['d170'], // Fl
		'275'   => self::$pics['d006'], // Ȃ
		'276'   => self::$pics['d091'], //  ()
		'277'   => '' . self::$pics['d225'] . '', // 
		'278'   => self::$pics['d155'], // Ԋ
		'279'   => self::$pics['d241'], // ۔
		'280'   => '[100_]',           // 100__
		'281'   => self::$pics['d153'], // p`
		'282'   => self::$pics['d164'], // _bV
		'283'   => '[E`]',          // E`}[N
		'284'   => '',                // lwTC
		'285'   => '()',              // }
		'286'   => '[hN]',          // ǂ
		'287'   => self::$pics['d228'], // уTC (w)
		'288'   => self::$pics['d077'], // er
		'289'   => self::$pics['d057'], // }CN
		'290'   => self::$pics['d204'], // z
		'291'   => self::$pics['d155'], // fB
		'292'   => '[M^[]',          // M^[ (GL)
		'293'   => '[oCI]',      // oCI (NVbN)
		'294'   => self::$pics['d061'], // wbhtH
		'295'   => self::$pics['d205'], // g
		'296'   => '[sXg]',        // ANV (sXg)
		'297'   => '[GXe]',          // GXe
		'298'   => '[EZ]',              // EZ }[N
		'299'   => self::$pics['d114'], //  (FREE)
		'300'   => self::$pics['d079'], // CD/DVD
		'301'   => self::$pics['d203'], // wl
		'302'   => '[UFO]',             // UFO
		'303'   => self::$pics['d150'], // XV (UP!)
		'304'   => '[]',            // ˊ ()
		'305'   => self::$pics['d007'], // 
		'306'   => self::$pics['d023'], // St
		'307'   => self::$pics['d027'], // oXPbg{[
		'308'   => self::$pics['d029'], // |Pbgx
		'309'   => self::$pics['d062'], // A[g
		'310'   => self::$pics['d063'], // 
		'311'   => self::$pics['d064'], // Cxg (T[JX)
		'312'   => self::$pics['d071'], // {
		'313'   => self::$pics['d073'], // o[Xf[
		'314'   => self::$pics['d081'], // Xy[h
		'315'   => self::$pics['d082'], // _C
		'316'   => self::$pics['d083'], // Nu
		'317'   => self::$pics['d084'], // 
		'318'   => self::$pics['d085'], // 
		'319'   => self::$pics['d087'], //  (`L)
		'320'   => self::$pics['d088'], //  (p[)
		'321'   => self::$pics['d095'], // V
		'322'   => self::$pics['d096'], // ⌇
		'323'   => self::$pics['d097'], // 
		'324'   => self::$pics['d118'], // NA
		'325'   => self::$pics['d134'], // lp 0
		'326'   => self::$pics['d135'], //  (OK)
		'327'   => self::$pics['d144'], // ӂӂ ()
		'328'   => self::$pics['d148'], // 킢
		'329'   => self::$pics['d161'], // ǂ (Ռ)
		'330'   => self::$pics['d162'], //  (юU銾)
		'331'   => '[ezplus]',          // C[W[vX
		'332'   => '[n]',            // n
		'333'   => self::$pics['d265'], // [
		'334'   => self::$pics['d120'], // NEW
		'335'   => self::$pics['d203'], // am
		'336'   => self::$pics['d092'], // amC
		'337'   => self::$pics['d211'], // p\R
		'338'   => self::$pics['d061'], // WI
		'339'   => self::$pics['d261'], // o
		'340'   => self::$pics['d208'], // `y
		'341'   => self::$pics['d031'], // nS
		'342'   => self::$pics['d253'], // xmR
		'343'   => self::$pics['d061'], // 
		'344'   => '[Vg]',            // Vg
		'345'   => '[]',              // g
		'346'   => '[F]',              // 
		'347'   => '[l]',              // ˂
		'348'   => self::$pics['d230'], // EBN ()
		'349'   => self::$pics['d227'], // ڂn[g ()
		'350'   => self::$pics['d276'], // VbLO ()
		'351'   => self::$pics['d221'], //  ()
		'352'   => '[]',              // 
		'353'   => '[Pbg]',        // Pbg
		'354'   => self::$pics['d215'], // 
		'355'   => self::$pics['d149'], // `[ (LXĂ)
		'356'   => '[n}[]',        // n}[
		'357'   => '[ԉ]',            // łグԉ
		'358'   => self::$pics['d260'], // ͂t
		'359'   => self::$pics['d069'], // d΂
		'360'   => '[]',            // 
		'361'   => '[Lv]',        // Lv
		'362'   => '[]',            // 
		'363'   => '[VS]',              // VS (o[TX)
		'364'   => '[gtB[]',      // gtB[
		'365'   => '[T]',              // J
		'366'   => '[XyC]',        // XyC
		'367'   => '[VA]',          // VA
		'368'   => '[H]',          // H
		'369'   => self::$pics['d147'], // C
		'370'   => '[j]',              // j}[N
		'371'   => '[[]',            // [X
		'372'   => '[]',              // 
		'373'   => '[]',            // 
		'374'   => '[x@]',            // |X
		'375'   => self::$pics['d040'], // X֋
		'376'   => self::$pics['d041'], // a@
		'377'   => self::$pics['d251'], // wZ
		'378'   => self::$pics['d044'], // ze
		'379'   => self::$pics['d036'], // D
		'380'   => self::$pics['d245'], // 18
		'381'   => '[.i|]',             // 
		'382'   => '[cool]',            // COOL!
		'383'   => '[]',              // }[N
		'384'   => '[T]',              // UE}[N
		'385'   => self::$pics['d115'], // ID}[N
		'386'   => self::$pics['d248'], // }[N
		'387'   => self::$pics['d246'], // }[N
		'388'   => '[w]',              // w}[N
		'389'   => '[c]',              // cƒ}[N
		'390'   => '',                // w
		'391'   => '',                // w
		'392'   => '[肢]',            // 肢 ()
		'393'   => self::$pics['d075'], // }i[[h
		'394'   => self::$pics['d075'], // dOFF
		'395'   => self::$pics['d076'], // 
		'396'   => '[lN^C]',        // lN^C
		'397'   => self::$pics['d148'], // nCrXJX
		'398'   => self::$pics['d148'], // ԑ
		'399'   => '[T{e]',        // T{e
		'400'   => self::$pics['d264'], // q & t
		'401'   => self::$pics['d053'], // t (r[)
		'402'   => '[j]',              // j}[N
		'403'   => '[]',              // ז (JvZ)
		'404'   => '[D]',            // D
		'405'   => '[NbJ[]',      // NbJ[
		'406'   => '[eznavi]',          // eznavigation
		'407'   => '[Xq]',            // Xq
		'408'   => self::$pics['d092'], // Ou[c
		'409'   => self::$pics['d205'], // lC
		'410'   => self::$pics['d056'], // e@
		'411'   => '[X]',          // 
		'412'   => '[]',            // 
		'413'   => '[]',            // rLj
		'414'   => self::$pics['d080'], // n[g (gv)
		'415'   => self::$pics['d136'], // n[g
		'416'   => self::$pics['d136'], // n[g
		'417'   => self::$pics['d136'], // ΃n[g
		'418'   => self::$pics['d136'], // n[g
		'419'   => self::$pics['d136'], // n[g
		'420'   => self::$pics['d150'], // 炫
		'421'   => self::$pics['d026'], // XL[
		'422'   => '',                // 
		'423'   => self::$pics['d219'], // {
		'424'   => self::$pics['d266'], // Hp
		'425'   => '[\tgN[]',  // \tgN[
		'426'   => '[|eg]',          // |eg
		'427'   => '[cq]',            // 
		'428'   => '[]',          // ׂ
		'429'   => '[]',            // ͂
		'430'   => '[XpQeB]',      // XpQeB
		'431'   => '[J[]',          // J[
		'432'   => '[ł]',          // ł
		'433'   => '[i]',            // i
		'434'   => self::$pics['d258'], // 
		'435'   => '[]',            // ݂
		'436'   => '[g}g]',          // g}g
		'437'   => '[֎q]',            // Ȃ
		'438'   => '[ٓ]',            // ٓ
		'439'   => '[]',              // 
		'440'   => self::$pics['d222'], // ӂ ()
		'441'   => self::$pics['d142'], // ڂ ()
		'442'   => self::$pics['d231'], // ւ ()
		'443'   => self::$pics['d143'], // s ()
		'444'   => self::$pics['d221'], // 킩
		'445'   => self::$pics['d157'], // 
		'446'   => self::$pics['d223'], // ĂĂ ()
		'447'   => self::$pics['d224'], //  ()
		'448'   => self::$pics['d232'], // ׂЂ
		'449'   => self::$pics['d225'], // M ()
		'450'   => self::$pics['d226'], //  ()
		'451'   => self::$pics['d276'], // т ()
		'452'   => self::$pics['d224'], //  ()
		'453'   => self::$pics['d155'], // y
		'454'   => self::$pics['d231'], // ɂɂ ()
		'455'   => self::$pics['d227'], // `[ 2 ()
		'456'   => self::$pics['d227'], // `b ()
		'457'   => '[@]',              // @
		'458'   => self::$pics['d149'], // 
		'459'   => '[S]',          // S^肢
		'460'   => self::$pics['d088'] . self::$pics['d088'], // 
		'461'   => self::$pics['d135'], // OK! (wŊۃTC)
		'462'   => self::$pics['d156'], // u[CO (w)
		'463'   => self::$pics['d088'], // oCoC
		'464'   => self::$pics['d236'], // NG (lR)
		'465'   => self::$pics['d135'], // OK! 2 (lR)
		'466'   => '[S]',          // ӂ (lR)
		'467'   => '[Jbv]',        // Jbv
		'468'   => '[oj[]',          // oj[
		'469'   => '[gybg]',      // gybg
		'470'   => '[r[h]',      // r[h
		'471'   => '[j]',            // j
		'472'   => self::$pics['d033'], // h
		'473'   => self::$pics['d033'], // ~}
		'474'   => self::$pics['d033'], // pgJ[
		'475'   => self::$pics['d032'], // WFbgR[X^[
		'476'   => '[叼]',            // 叼
		'477'   => '[Ղ]',          // Ղ
		'478'   => '[Ǝ]',          // Ǝ
		'479'   => '[w]',          // w
		'480'   => self::$pics['d270'], // ̂ڂ
		'481'   => self::$pics['d008'], // P
		'482'   => self::$pics['d170'], // ԉ
		'483'   => '[X]',          // X
		'484'   => '[ԉ]',        // ԉ
		'485'   => '[L]',            // L
		'486'   => '[]',            // 
		'487'   => '[nEB]',      // nEB
		'488'   => self::$pics['d172'], // 
		'489'   => '[T^]',          // T^
		'490'   => self::$pics['d172'], // ^ꐯ
		'491'   => '[]',              // 
		'492'   => self::$pics['d044'], // ze 2
		'493'   => self::$pics['d001'], // ̏o
		'494'   => self::$pics['d063'], // VNnbg
		'495'   => self::$pics['d039'], // fp[g
		'496'   => self::$pics['d039'], //  ({)
		'497'   => self::$pics['d039'], //  ([bp)
		'498'   => self::$pics['d039'], // H 2
		'499'   => '[tX]',        // tX
		'500'   => '[I[vEF[u]',// I[vEF[u
		'501'   => self::$pics['d116'], // bNmF
		'502'   => '[ABC]',             // 啶
		'503'   => '[abc]',             // 
		'504'   => '[012]',             // 
		'505'   => '[,@#]',             // L
		'506'   => '[]',              // ANZvg
		'507'   => '[]',              // `FbN{bNX
		'508'   => self::$pics['d169'], // GfBbg
		'509'   => '',                // WI{^
		'510'   => self::$pics['d119'], //  (ዾ)
		'511'   => self::$pics['d117'], // ߂
		'512'   => self::$pics['d076'], // Cɓ
		'513'   => self::$pics['d175'], // I
		'514'   => self::$pics['d038'], // z[
		'515'   => self::$pics['d106'], // M 1
		'516'   => '',                // }[N
		'517'   => self::$pics['d116'], // l ()
		'518'   => self::$pics['d242'], // ēǂݍ
		'700'   => '[hCc]',          // hCc
		'701'   => '[C^A]',        // C^A
		'702'   => '[CMX]',        // CMX
		'703'   => '[]',            // 
		'704'   => '[؍]',            // ؍
		'705'   => '[l]',            // l
		'706'   => '[l]',          // l
		'707'   => '[Chl]',        // Chl
		'708'   => self::$pics['d170'], // 
		'709'   => self::$pics['d170'], // ΂
		'710'   => self::$pics['d222'], // Ԃ
		'711'   => self::$pics['d170'], // H̐l
		'712'   => self::$pics['d170'], // Pl
		'713'   => self::$pics['d270'], // CJ
		'714'   => '[_X]',          // _X
		'715'   => self::$pics['d270'], // Mы
		'716'   => '[ђ]',            // 
		'717'   => '[]',              // 
		'718'   => '[RA]',          // RA
		'719'   => '[]',              // zX^C
		'720'   => '[]',              // wr
		'721'   => self::$pics['d268'], // {
		'722'   => '[]',              // ڂ
		'723'   => '[N_]',          // ӂԂ炭
		'724'   => '[A^]',             // A^
		'725'   => '[B^]',             // B^
		'726'   => '[O^]',             // O^
		'727'   => '[AB^]',            // AB^
		'728'   => self::$pics['d091'], // 
		'729'   => self::$pics['d092'], // Xj[J[
		'730'   => self::$pics['d121'], // 
		'731'   => self::$pics['d145'], // J[u
		'732'   => self::$pics['d156'], // J[u
		'733'   => self::$pics['d159'], // u!?v
		'734'   => self::$pics['d160'], // u!!v
		'735'   => self::$pics['d166'], // 
		'736'   => '[]',          // 
		'737'   => '[pCibv]',    // pCibv
		'738'   => '[]',            // Ԃǂ
		'739'   => self::$pics['d257'], // oii
		'740'   => '[Ƃ낱]',    // Ƃ낱
		'741'   => '[̂]',          // ̂
		'742'   => '[I]',              // I
		'743'   => '[]',              // 
		'744'   => '[Ĉ]',            // ₫
		'745'   => '[sU]',            // sU
		'746'   => '[^[L[]',        // ^[L[
		'747'   => '[[]',            // [
		'748'   => self::$pics['d275'], // gsJhN
		'749'   => '[C]',              // C
		'750'   => '[sAm]',          // sAm
		'751'   => self::$pics['d252'], // T[tB
		'752'   => self::$pics['d275'], // ނ
		'753'   => '[{EO]',      // {EO
		'754'   => '[Ȃ܂͂]',        // Ȃ܂͂
		'755'   => self::$pics['d225'], // V
		'756'   => '[p_]',          // p_
		'757'   => self::$pics['d229'], // ׁ[
		'758'   => self::$pics['d274'], // Ԃ̕@
		'759'   => self::$pics['d148'], // 
		'760'   => '[ACXN[]',  // ACXN[
		'761'   => '',                // h[ic
		'762'   => '[NbL[]',        // NbL[
		'763'   => '[`R]',          // `R
		'764'   => '[LfB]',      // LfB ()
		'765'   => '[؂؂LfB]',// LfB (؂؂)
		'766'   => '(/__)',            //  ()
		'767'   => '(ExE)',           // 킴 ()
		'768'   => '|(E_E)|',         //  ()
		'769'   => self::$pics['d253'], // ΎR
		'770'   => self::$pics['d136'] . self::$pics['d071'], // {̃n[g
		'771'   => '[ABC]',             // puABCv
		'772'   => '[v]',          // v
		'773'   => '[I]',            // ~co`
		'774'   => '[ĂƂ]',      // egEV
		'775'   => '[I|bg]',      // I|bg
		'776'   => self::$pics['d258'], // 
		'777'   => self::$pics['d113'], // Ĥ͂D
		'778'   => self::$pics['d006'], // ڂ܂鎞̋L
		'779'   => self::$pics['d225'], // Ձ[ (킢{)
		'780'   => self::$pics['d225'], // Ձ[ (킢{) (lR)
		'781'   => self::$pics['d172'], // V̐
		'782'   => self::$pics['d227'], // `[ (lR)
		'783'   => self::$pics['d231'], // ɂ (lR)
		'784'   => self::$pics['d105'], // [
		'785'   => self::$pics['d231'], // ΂ (lR)
		'786'   => self::$pics['d231'], // ΂ ()
		'787'   => self::$pics['d227'], // ڂn[g (lR)
		'788'   => self::$pics['d234'], // ق[ (lR)
		'789'   => self::$pics['d234'], // ق[ ()
		'790'   => self::$pics['d235'], // ܂ۂ (lR)
		'791'   => self::$pics['d235'], // ܂ۂ ()
		'792'   => self::$pics['d226'], //  (lR)
		'793'   => '[hX]',          // hX
		'794'   => '[C]',        // C
		'795'   => '[w]',              // w
		'796'   => '[ԎD]',            // ԎD
		'797'   => '[W[J[]',      // W[J[
		'798'   => '[CVtC]',      // GrtC
		'799'   => self::$pics['d110'], // e[ACR
		'800'   => self::$pics['d240'], // l
		'801'   => '[pgJ[]',        // pgJ[̃v
		'802'   => self::$pics['d058'], // ezmovie
		'803'   => self::$pics['d137'], // hLhLĂn[g
		'804'   => self::$pics['d268'], // ʌ̂Ђ悱
		'805'   => self::$pics['d206'], // W[Y
		'806'   => self::$pics['d212'], // n[g[
		'807'   => self::$pics['d242'], // z
		'808'   => self::$pics['d249'], // E
		'809'   => self::$pics['d250'], // ㉺
		'810'   => self::$pics['d252'], // rg
		'811'   => self::$pics['d259'], // ot
		'812'   => self::$pics['d267'], // ނ
		'813'   => self::$pics['d272'], //  (lR)
		'814'   => self::$pics['d272'], //  ()
		'815'   => self::$pics['d110'], // C[ACR
		'816'   => self::$pics['d259'], // n[u
		'817'   => self::$pics['d086'], //  (O[)
		'818'   => self::$pics['d123'], // u#v
		'819'   => self::$pics['d140'], //  (LN^[)
		'820'   => self::$pics['d231'], //  (LN^[)
		'821'   => self::$pics['d142'], // ڂ (LN^[)
		'822'   => self::$pics['d225'], // 킢{ (LN^[)
		'se001' => self::$pics['d140'], // j̎q
		'se002' => self::$pics['d140'], // ̎q
		'se003' => self::$pics['d149'], // e (LX}[N)
		'se004' => self::$pics['d140'], // 
		'se005' => self::$pics['d140'], // ꂳ
		'se006' => self::$pics['d203'], // m
		'se007' => self::$pics['d092'], // u[c
		'se008' => self::$pics['d068'], // J
		'se009' => self::$pics['d074'], // db
		'se00a' => self::$pics['d075'], // gѓdb
		'se00b' => self::$pics['d107'], // FAX
		'se00c' => self::$pics['d211'], // p\R
		'se00d' => self::$pics['d153'], // p`
		'se00e' => self::$pics['d228'], // GOOD!
		'se00f' => '[No.1!]',           // No.1!
		'se010' => self::$pics['d086'], // O[
		'se011' => self::$pics['d087'], // `L
		'se012' => self::$pics['d088'], // p[
		'se013' => self::$pics['d026'], // XL[
		'se014' => self::$pics['d023'], // St
		'se015' => self::$pics['d024'], // ejX
		'se016' => self::$pics['d022'], // 싅
		'se017' => self::$pics['d207'], // T[tB
		'se018' => self::$pics['d025'], // TbJ[
		'se019' => self::$pics['d270'], // 
		'se01a' => self::$pics['d273'], // 
		'se01b' => self::$pics['d033'], // 
		'se01c' => self::$pics['d102'], // bg
		'se01d' => self::$pics['d037'], // s@
		'se01e' => self::$pics['d030'], // d
		'se01f' => self::$pics['d032'], // V
		'se020' => '?',                 // nei
		'se021' => self::$pics['d158'], // rbN
		'se022' => self::$pics['d136'], // n[g}[N
		'se023' => self::$pics['d138'], // n[guCN
		'se024' => self::$pics['d176'], // 1
		'se025' => self::$pics['d176'], // 2
		'se026' => self::$pics['d176'], // 3
		'se027' => self::$pics['d176'], // 4
		'se028' => self::$pics['d176'], // 5
		'se029' => self::$pics['d176'], // 6
		'se02a' => self::$pics['d176'], // 7
		'se02b' => self::$pics['d176'], // 8
		'se02c' => self::$pics['d176'], // 9
		'se02d' => self::$pics['d176'], // 10
		'se02e' => self::$pics['d176'], // 11
		'se02f' => self::$pics['d176'], // 12
		'se030' => self::$pics['d176'], // Ԍ
		'se031' => self::$pics['d215'], // Gu
		'se032' => self::$pics['d261'], // o
		'se033' => self::$pics['d103'], // NX}X
		'se034' => self::$pics['d216'], // w
		'se035' => self::$pics['d216'], // 
		'se036' => self::$pics['d038'], // 
		'se037' => '[]',            // 
		'se038' => self::$pics['d039'], // r
		'se039' => '[w]',              // w
		'se03a' => self::$pics['d046'], // K\X^h
		'se03b' => self::$pics['d253'], // R
		'se03c' => self::$pics['d057'], // }CN
		'se03d' => self::$pics['d058'], // f
		'se03e' => self::$pics['d146'], // y
		'se03f' => self::$pics['d116'], // JM
		'se040' => '[TbNX]',        // TbNX
		'se041' => '[M^[]',          // M^[
		'se042' => '[gybg]',    // gybg
		'se043' => self::$pics['d050'], // Xg
		'se044' => self::$pics['d052'], // JNe
		'se045' => self::$pics['d051'], // R[q[
		'se046' => self::$pics['d263'], // P[L
		'se047' => self::$pics['d053'], // r[
		'se048' => self::$pics['d004'], // 
		'se049' => self::$pics['d002'], // ܂
		'se04a' => self::$pics['d001'], //  ()
		'se04b' => self::$pics['d003'], // J
		'se04c' => self::$pics['d098'], //  ()
		'se04d' => self::$pics['d001'], // 
		'se04e' => '[Vg]',            // Vg
		'se04f' => self::$pics['d101'], // ˂
		'se050' => '[]',              // Ƃ
		'se051' => '[F]',              // 
		'se052' => self::$pics['d100'], // 
		'se053' => '[l]',              // ˂
		'se054' => '[~]',              // NW
		'se055' => self::$pics['d269'], // yM
		'se056' => self::$pics['d140'], // y ()
		'se057' => self::$pics['d231'], //  ()
		'se058' => self::$pics['d142'], //  ()
		'se059' => self::$pics['d141'], // { ()
		'se05a' => '[E`]',          // E`
		'se101' => self::$pics['d106'], // [M
		'se102' => self::$pics['d110'] . '', // [M
		'se103' => self::$pics['d106'], // [
		'se104' => self::$pics['d105'], // dbA
		'se105' => self::$pics['d229'], // AJx[ ()
		'se106' => self::$pics['d227'], // uu ()
		'se107' => self::$pics['d276'], // Kr[ ()
		'se108' => self::$pics['d224'], // ^[ ()
		'se109' => '[]',              // 
		'se10a' => '[]',              // ^R
		'se10b' => self::$pics['d274'], // Ԃ
		'se10c' => self::$pics['d170'], // Fl
		'se10d' => '[Pbg]',        // Pbg
		'se10e' => self::$pics['d215'], // 
		'se10f' => self::$pics['d151'], // d
		'se110' => self::$pics['d254'], // 
		'se111' => self::$pics['d149'], // LX
		'se112' => self::$pics['d072'], // o[Xf[ (v[g)
		'se113' => '[sXg]',        // sXg
		'se114' => self::$pics['d119'], // ዾ
		'se115' => self::$pics['d240'], // 
		'se116' => '[I[NV]',    // I[NV
		'se117' => self::$pics['d150'], // ԉ
		'se118' => self::$pics['d260'], // ݂
		'se119' => self::$pics['d260'], // t
		'se11a' => '[]',            // 
		'se11b' => '[]',          // ΂
		'se11c' => '[hN]',          // hN
		'se11d' => '[]',              // t@C[
		'se11e' => self::$pics['d069'], // ΂
		'se11f' => self::$pics['d171'], // 
		'se120' => self::$pics['d054'], // no[K[
		'se121' => '[]',            // 
		'se122' => '[Lv]',        // Lv
		'se123' => self::$pics['d147'], // 
		'se124' => self::$pics['d060'], // Vn
		'se125' => self::$pics['d065'], // `Pbg
		'se126' => self::$pics['d079'], // CD
		'se127' => self::$pics['d079'], // DVD
		'se128' => self::$pics['d061'], // WI
		'se129' => '[rfI]',          // rfI
		'se12a' => self::$pics['d077'], // er
		'se12b' => self::$pics['d078'], // Q[
		'se12c' => self::$pics['d146'], // ̂o
		'se12d' => '[]',            // }[W
		'se12e' => '[VS]',              // Ό
		'se12f' => self::$pics['d210'], // ܋ (h)
		'se130' => '[]',          // 
		'se131' => '[gtB[]',      // gtB[
		'se132' => self::$pics['d028'], // S[ (`FbJ[tbO)
		'se133' => '[777]',             // Xbg (777)
		'se134' => self::$pics['d273'], // n
		'se135' => self::$pics['d102'], // 
		'se136' => self::$pics['d218'], // 
		'se137' => '[H]',          // H
		'se138' => '',                // j
		'se139' => '',                // 
		'se13a' => '[Ԃ]',        // c
		'se13b' => '[]',            // ˊ
		'se13c' => self::$pics['d157'], //  (Zzz)
		'se13d' => self::$pics['d005'], // 
		'se13e' => self::$pics['d055'], // nCq[
		'se13f' => self::$pics['d147'], // 
		'se140' => self::$pics['d049'], // gC
		'se141' => '[]',            // 
		'se142' => '[Kz]',        // m点 (Kz)
		'se143' => '[j]',            // j
		'se144' => self::$pics['d116'], // bNON
		'se145' => self::$pics['d116'], // bNOFF
		'se146' => '[X]',              // X
		'se147' => '[]',            //  ()
		'se148' => self::$pics['d070'], // {
		'se149' => '[$\\]',             // ב֑
		'se14a' => '[]',            // 
		'se14b' => '[p{]',        // j[X (p{Aei)
		'se14c' => '[͂]',          // C (͂)
		'se14d' => self::$pics['d042'], // s
		'se14e' => self::$pics['d048'], // M
		'se14f' => self::$pics['d047'], // ԏ
		'se150' => self::$pics['d035'], // oX
		'se151' => self::$pics['d049'], // OgC
		'se152' => '[]',            // 
		'se153' => self::$pics['d040'], // X֋
		'se154' => self::$pics['d043'], // ATM
		'se155' => self::$pics['d041'], // a@
		'se156' => self::$pics['d045'], // Rrj
		'se157' => self::$pics['d251'], // wZ
		'se158' => self::$pics['d044'], // ze
		'se159' => self::$pics['d035'], // oX
		'se15a' => self::$pics['d033'], // ^NV[
		'se201' => self::$pics['d240'], // k
		'se202' => self::$pics['d036'], // D
		'se203' => '[RR]',            // ړIn (RR)
		'se204' => self::$pics['d148'], // r1
		'se205' => self::$pics['d148'], // r2
		'se206' => self::$pics['d148'], // r3
		'se207' => self::$pics['d245'], // 18
		'se208' => self::$pics['d067'], // ։
		'se209' => '[S]',          // S
		'se20a' => self::$pics['d094'], // oAt[ (Ԉ֎q}[N)
		'se20b' => '[.i|]',             // Aei}[N
		'se20c' => self::$pics['d080'], // n[g (gv)
		'se20d' => self::$pics['d082'], // _C (gv)
		'se20e' => self::$pics['d081'], // Xy[h (gv)
		'se20f' => self::$pics['d083'], // Nu (gv)
		'se210' => self::$pics['d123'], // V[v_C
		'se211' => self::$pics['d122'], // t[_C
		'se212' => self::$pics['d120'], // V
		'se213' => self::$pics['d150'], // XV
		'se214' => self::$pics['d093'], //  (COOL)
		'se215' => self::$pics['d113'], // L
		'se216' => self::$pics['d114'], // 
		'se217' => '[]',              // z
		'se218' => '[\]',              // \
		'se219' => '',                // o{^1 (IW)
		'se21a' => '',                // o{^2 ()
		'se21b' => '',                // o{^4 ()
		'se21c' => self::$pics['d125'], // 1 (one)
		'se21d' => self::$pics['d126'], // 2 (two)
		'se21e' => self::$pics['d127'], // 3 (three)
		'se21f' => self::$pics['d128'], // 4 (four)
		'se220' => self::$pics['d129'], // 5 (five)
		'se221' => self::$pics['d130'], // 6 (six)
		'se222' => self::$pics['d131'], // 7 (seven)
		'se223' => self::$pics['d132'], // 8 (eight)
		'se224' => self::$pics['d133'], // 9 (nine)
		'se225' => self::$pics['d134'], // 0 (zero)
		'se226' => '[]',              // 
		'se227' => '[]',              // 
		'se228' => '[T]',              // T[rX
		'se229' => self::$pics['d115'], // ID
		'se22a' => self::$pics['d248'], // 
		'se22b' => self::$pics['d246'], // 
		'se22c' => '[w]',              // w
		'se22d' => '[c]',              // cƎ
		'se22e' => '',                //  (w)
		'se22f' => '',                //  (w)
		'se230' => '',                //  (w)
		'se231' => '',                // E (w)
		'se232' => '',                // 
		'se233' => '',                // 
		'se234' => '',                // E
		'se235' => '',                // 
		'se236' => self::$pics['d059'], // E
		'se237' => self::$pics['d090'], // 
		'se238' => self::$pics['d089'], // E
		'se239' => self::$pics['d104'], // 
		'se23a' => '',                // 
		'se23b' => '',                // O
		'se23c' => '',                //  
		'se23d' => '',                // ߂
		'se23e' => '[]',              // 
		'se23f' => self::$pics['d009'], // Ђ
		'se240' => self::$pics['d010'], // 
		'se241' => self::$pics['d011'], // ӂ
		'se242' => self::$pics['d012'], // ɍ
		'se243' => self::$pics['d013'], // 
		'se244' => self::$pics['d014'], // Ƃߍ
		'se245' => self::$pics['d015'], // Ă҂
		'se246' => self::$pics['d016'], // 
		'se247' => self::$pics['d017'], // č
		'se248' => self::$pics['d018'], // €
		'se249' => self::$pics['d019'], // ݂ߍ
		'se24a' => self::$pics['d020'], // 
		'se24b' => '[֌]',          // ւт
		'se24c' => '[TOP]',             // TOPy[W
		'se24d' => self::$pics['d135'], // OK{^
		'se24e' => self::$pics['d238'], // 쌠 (C)
		'se24f' => self::$pics['d243'], // o^W (R)
		'se250' => self::$pics['d075'], // }i[[h
		'se251' => self::$pics['d075'], // d
		'se252' => self::$pics['d244'], //  (!)
		'se253' => self::$pics['d170'], // ē
		'se254' => self::$pics['d039'], // J-PHONEVbv
		'se255' => self::$pics['d012'], // XJCEFu
		'se256' => self::$pics['d110'], // XJCEH[J[
		'se257' => self::$pics['d146'] . self::$pics['d106'] , // XJCfB
		'se258' => 'J-',                // J-PHONE 1
		'se259' => 'Pho',               // J-PHONE 2
		'se25a' => 'ne',                // J-PHONE 3
		'se301' => self::$pics['d076'], // 
		'se302' => '[lN^C]',        // lN^C
		'se303' => self::$pics['d148'], // nCrXJX
		'se304' => self::$pics['d256'], // `[bv
		'se305' => self::$pics['d148'], // Ђ܂
		'se306' => self::$pics['d150'], // ԑ
		'se307' => '[q̖]',        // ₵̖
		'se308' => '[T{e]',        // T{e
		'se309' => self::$pics['d049'], // gC
		'se30a' => self::$pics['d061'], // wbhz
		'se30b' => self::$pics['d264'], // ӎ (Ƃ)
		'se30c' => self::$pics['d053'], // t (r[)
		'se30d' => '(j)',              // j
		'se30e' => self::$pics['d066'], // i
		'se30f' => '[]',              // JvZ
		'se310' => '[D]',            // D
		'se311' => self::$pics['d154'], // e
		'se312' => '[NbJ[]',      // NbJ[
		'se313' => self::$pics['d056'], // nT~
		'se314' => self::$pics['d071'], // {
		'se315' => self::$pics['d241'], // }
		'se316' => '[MD]',              // MD
		'se317' => '[Kz]',        // KtH
		'se318' => self::$pics['d063'], // Xq
		'se319' => '[hX]',          // s[X
		'se31a' => self::$pics['d055'], // ~[
		'se31b' => '[u[c]',          // Ou[c
		'se31c' => self::$pics['d205'], // g
		'se31d' => '[}jLA]',      // }jLA
		'se31e' => '[GXe]',          // GXe
		'se31f' => self::$pics['d056'], // e@
		'se320' => self::$pics['d056'], // X
		'se321' => '[]',            // 
		'se322' => '[rLj]',          // rLj
		'se323' => self::$pics['d069'], // uhobO
		'se324' => self::$pics['d167'], // J`R
		'se325' => self::$pics['d208'], // 
		'se326' => self::$pics['d155'], // x鉹
		'se327' => self::$pics['d137'], // ҂҂n[g
		'se328' => self::$pics['d137'], // hLhLn[g
		'se329' => '' . self::$pics['d136'], // n[g˂Ƃ߂
		'se32a' => self::$pics['d136'], // n[g ()
		'se32b' => self::$pics['d136'], // n[g ()
		'se32c' => self::$pics['d136'], // n[g ()
		'se32d' => self::$pics['d136'], // n[g ()
		'se32e' => self::$pics['d150'], // NEW
		'se32f' => '',                // 
		'se330' => self::$pics['d164'], // _bV
		'se331' => self::$pics['d162'], // юU銾
		'se332' => self::$pics['d099'], // 
		'se333' => '~',                // ~
		'se334' => self::$pics['d152'], // {
		'se335' => '',                //  (_)
		'se336' => '?',                 //  "?"
		'se337' => self::$pics['d158'], //  "!"
		'se338' => self::$pics['d219'], // 
		'se339' => self::$pics['d266'], // p
		'se33a' => '[\tgN[]',  // \tgN[
		'se33b' => '[|eg]',          // tCh|eg
		'se33c' => '[cq]',            // cq 
		'se33d' => '[]',          // ׂ
		'se33e' => self::$pics['d265'], // 
		'se33f' => '[XpQeB]',      // XpQeB
		'se340' => self::$pics['d265'], // [
		'se341' => '[J[]',          // J[CX
		'se342' => self::$pics['d262'], // ɂ
		'se343' => '[ł]',          // ł
		'se344' => '[i]',            // i
		'se345' => self::$pics['d258'], // 
		'se346' => '[]',            // ݂
		'se347' => '[]',              // 
		'se348' => '[Z]',            // 
		'se349' => '[g}g]',          // g}g
		'se34a' => '[֎q]',            // Ȃ
		'se34b' => self::$pics['d073'], // o[Xf[P[L
		'se34c' => '[w]',            // w
		'se34d' => '[]',              // ix
		'se401' => self::$pics['d224'], //  ()
		'se402' => self::$pics['d233'], // قł ()
		'se403' => self::$pics['d221'], // Ђ炲߂Ȃ ()
		'se404' => self::$pics['d272'], // ւ ()
		'se405' => self::$pics['d230'], // EBN ()
		'se406' => self::$pics['d232'], // 킳т ()
		'se407' => self::$pics['d143'], // ڂ邮 ()
		'se408' => self::$pics['d157'], // @傤 ()
		'se409' => self::$pics['d229'], // ׁ[ ()
		'se40a' => self::$pics['d222'], //  ()
		'se40b' => self::$pics['d276'], // QQ ()
		'se40c' => '(##)',            // }XN
		'se40d' => self::$pics['d231'], // 炪Ȃ
		'se40e' => self::$pics['d226'], // 炯
		'se40f' => self::$pics['d224'], // ⊾ ()
		'se410' => self::$pics['d144'], // т ()
		'se411' => self::$pics['d234'], //  ()
		'se412' => self::$pics['d234'], // ΂ ()
		'se413' => self::$pics['d235'], // Ăl
		'se414' => self::$pics['d140'], // ɂɂ ()
		'se415' => self::$pics['d231'], // ͂͂Ə΂ ()
		'se416' => self::$pics['d225'], // ߂߂{Ă ()
		'se417' => self::$pics['d227'], // KISS:
		'se418' => self::$pics['d227'], // KISS
		'se419' => self::$pics['d084'], // 
		'se41a' => '[@]',              // @
		'se41b' => self::$pics['d085'], // 
		'se41c' => self::$pics['d149'], // 
		'se41d' => '[S]',          // ߂Ȃ (킹)
		'se41e' => self::$pics['d088'], // oCoC (U)
		'se41f' => self::$pics['d088'] . self::$pics['d088'],// 
		'se420' => self::$pics['d135'], // OK (wŊۃTC)
		'se421' => self::$pics['d156'], // Booing (ew)
		'se422' => self::$pics['d088'], // ́`
		'se423' => self::$pics['d236'], // ~ (rNX)
		'se424' => self::$pics['d135'], //  (r𓪂)
		'se425' => self::$pics['d137'], // Ȃł
		'se426' => 'm(__)m',            // y
		'se427' => '_(^o^)^',         // oUC
		'se428' => self::$pics['d170'] . self::$pics['d170'], // lƐlĂ
		'se429' => '[oj[]',          // C_X (oj[K[)
		'se42a' => self::$pics['d027'], // oXPbg{[
		'se42b' => '[Atg]',        // tbg{[
		'se42c' => '[r[h]',      // r[h
		'se42d' => self::$pics['d252'], // j
		'se42e' => self::$pics['d034'], // RV
		'se42f' => '[gbN]',        // gbN
		'se430' => '[h]',          // h
		'se431' => '[~}]',          // ~}
		'se432' => '[pgJ[]',        // pgJ[
		'se433' => '[[[R[X^[]',// WFbgR[X^[
		'se434' => self::$pics['d031'], // nS
		'se435' => self::$pics['d032'], // V(700n)
		'se436' => '[叼]',            // 叼
		'se437' => '[`R]',          // `R
		'se438' => '[l]',          // l
		'se439' => '[Ǝ]',          // Ǝ
		'se43a' => '[hZ]',      // hZ
		'se43b' => '[̂ڂ]',        // ̂ڂ
		'se43c' => self::$pics['d008'], // Ƃ
		'se43d' => '[]',          // 
		'se43e' => self::$pics['d252'], // gU[
		'se43f' => '[X]',          // X
		'se440' => '[ԉ]',        // ԉ
		'se441' => '[L]',              // L
		'se442' => '[]',            // 
		'se443' => self::$pics['d006'], // 䕗
		'se444' => '[]',            // 
		'se445' => '[nEB]',      // nEB
		'se446' => self::$pics['d099'], // 
		'se447' => self::$pics['d260'], // r[
		'se448' => '[T^]',          // T^N[X
		'se449' => self::$pics['d001'], // 
		'se44a' => self::$pics['d001'], // [
		'se44b' => self::$pics['d172'], // ꐯ
		'se44c' => '[]',              // 
		'se501' => self::$pics['d044'] . self::$pics['d136'], // uze
		'se502' => self::$pics['d062'], // A[g
		'se503' => self::$pics['d063'], // 
		'se504' => self::$pics['d039'], // fp[g
		'se505' => '[Vt]',          //  (a)
		'se506' => '[]',              //  (m)
		'se507' => self::$pics['d058'], // f
		'se508' => self::$pics['d039'], // H
		'se509' => '[^[]',      // ^[ 
		'se50a' => self::$pics['d039'], // 109 
		'se50b' => '[{]',            // { 
		'se50c' => '[AJ]',        // AJ 
		'se50d' => '[tX]',        // tX 
		'se50e' => '[hCc]',          // hCc 
		'se50f' => '[C^A]',        // C^A 
		'se510' => '[CMX]',        // CMX 
		'se511' => '[XyC]',        // XyC 
		'se512' => '[VA]',          // VA 
		'se513' => '[]',            //  
		'se514' => '[؍]',            // ؍ 
		'se515' => '[l]',            // l 
		'se516' => '[l]',          // l 
		'se517' => '[Chl]',        // Chl 
		'se518' => '[]',    // 
		'se519' => '[΂]',    // ΂
		'se51a' => '[Ԃ]',        // 
		'se51b' => '[Hl]',          // S
		'se51c' => '[Pl]',          // P
		'se51d' => '[Ȑ_]',      // Ȑ_
		'se51e' => '[q]',            // q
		'se51f' => '[tR]',      // tR
		'se520' => self::$pics['d270'], // CJ
		'se521' => self::$pics['d268'], // Ƃ
		'se522' => self::$pics['d270'], // Mы
		'se523' => self::$pics['d268'], // Ђ悱
		'se524' => '[nX^[]',      // nX^[
		'se525' => '[ђ]',            // ނ
		'se526' => '[]',              // 
		'se527' => '[RA]',          // RA
		'se528' => '[`pW[]',    // `pW[
		'se529' => '[r]',              // Ђ
		'se52a' => self::$pics['d100'], // 
		'se52b' => '[]',              // 
		'se52c' => '[e]',              // 
		'se52d' => '[]',              // ւ
		'se52e' => self::$pics['d268'], // ɂƂ
		'se52f' => '[]',              // ̂
		'se530' => '[N_]',          // 炭
		'se531' => '[^]',              // 
		'se532' => '[A^]',             // A^
		'se533' => '[B^]',             // B^
		'se534' => '[AB^]',            // AB^
		'se535' => '[O^]',             // O^
		'se536' => self::$pics['d091'], // 
		'se537' => self::$pics['d239'], // TM (W)
		'se538' => 'J-', 
		'se539' => 'Sky', 
		'se53a' => 'g', 
		'se53b' => 'h', 
		'se53c' => 'V', 
		'se53d' => 'odaf', 
		'se53e' => 'one', 
		'e253'  => '[w]',              // lw
		'e254'  => self::$pics['d049'], // Jbv
		'e255'  => '[S]',          // t}[N
		'e256'  => '[M^[]',          // M^[
		'e257'  => '[]',            // `[g
		'e258'  => self::$pics['d245'], // 18Έȏ֎~
		'e259'  => '[]',            // v
		'e260'  => '[R~jeB]',    // R~jeB
		'e261'  => '[HIT]',             // qbg
		'e262'  => self::$pics['d076'], // V
		'e263'  => '[T^]',          // T^N[X
		'e264'  => '[Ƒ]',            // Ƒ
		'e265'  => '@',                // [gp]
		'e266'  => '',                // RC
		'e267'  => '@',                // [gp]
		'e268'  => '@',                // [gp]
		'e269'  => 'EM',                // EMOBILE S (n)
		'e270'  => 'EM',                // EMOBILE S (Ԓn)
		'e271'  => '@',                // [gp]
		'e272'  => '@',                // [gp]
		'e273'  => '@',                // [gp]
		'e274'  => '@',                // [gp]
		'e275'  => '@',                // [gp]
		'e276'  => '@',                // [gp]
		'e277'  => '@',                // [gp]
		'e278'  => '@',                // [gp]
		'wf040' => self::$pics['d080'], // n[g
		'wf041' => self::$pics['d176'], // |v
		'wf042' => self::$pics['d074'], // db
		'wf043' => self::$pics['d051'], // }OJbv
		'wf044' => '*',                 // *
		'wf045' => self::$pics['d250'], // ㉺
		'wf046' => self::$pics['d249'], // E
		'wf047' => '(((',               // (((
		'wf048' => self::$pics['d001'], // 
		'wf049' => self::$pics['d003'], // J
		'wf04a' => self::$pics['d002'], // ܂
		'wf04b' => self::$pics['d163'], // 
		'wf04c' => self::$pics['d140'], // Ί
		'wf04d' => self::$pics['d149'], // LX}[N
		'wf04e' => self::$pics['d146'], // \Z
		'wf04f' => self::$pics['d033'], // 
		'wf050' => self::$pics['d030'], // d
		'wf051' => self::$pics['d037'], // s@
		'wf052' => '[oCN]'         , // oCN
		'wf053' => self::$pics['d038'], // 
		'wf054' => self::$pics['d039'], // r
		'wf055' => self::$pics['d087'], //  (`L)
		'wf056' => self::$pics['d050'], // iCtƃtH[N (Xg)
		'wf057' => self::$pics['d052'], // }eB[j (JNe)
		'wf058' => self::$pics['d235'], // ܊
		'wf059' => self::$pics['d256'], // `[bv
		'wf05a' => self::$pics['d022'], // obg
		'wf05b' => self::$pics['d022'], // 싅{[
		'wf05c' => self::$pics['d086'], //  (O[)
		'wf05d' => self::$pics['d005'], // 
		'wf05e' => self::$pics['d141'], // {
		'wf05f' => self::$pics['d053'], // r[
		'wf060' => self::$pics['d076'], // m[g
		'wf061' => self::$pics['d214'], // M
		'wf062' => '[hN]',          // hN
		'wf063' => self::$pics['d110'], // [
		'wf064' => self::$pics['d067'], // ։
		'wf065' => self::$pics['d097'], // x
		'wf066' => self::$pics['d148'], // 
		'wf067' => self::$pics['d147'], // 
		'wf068' => self::$pics['d098'], // \Z
		'wf069' => self::$pics['d121'], // 
		'wf06a' => '[]',            // }XN
		'wf06b' => self::$pics['d061'], // y
		'wf06c' => '[]',              // 
		'wf06d' => self::$pics['d100'], // 
		'wf06e' => self::$pics['d101'], // L
		'wf06f' => '[]',              // 
		'wf070' => '[]',              // 
		'wf071' => '[]',              // 
		'wf072' => self::$pics['d265'], // [
		'wf073' => self::$pics['d057'], // }CN (JIP)
		'wf074' => self::$pics['d152'], // {}[N
		'wf075' => self::$pics['d268'], // Ђ悱
		'wf076' => self::$pics['d157'], // 
		'wf077' => self::$pics['d051'], // R[q[Jbv
		'wf078' => self::$pics['d066'], // i
		'wf079' => self::$pics['d162'], // юU銾
		'wf07a' => self::$pics['d262'], // ɂ
		'wf07b' => self::$pics['d069'], // obO
		'wf07c' => '[E`]',          // E`
		'wf07d' => '[lN^C]',        // lN^C
		'wf07e' => self::$pics['d203'], // TVc
		'wf080' => '[Z]',            // Z
		'wf081' => '[X]',          // X
		'wf082' => '[]',            // 
		'wf083' => self::$pics['d056'], // 
		'wf084' => '[]',            // ˊ
		'wf085' => self::$pics['d036'], // d
		'wf086' => '[^]',              // ^
		'wf087' => self::$pics['d088'], //  (p[)
		'wf088' => self::$pics['d138'], // 
		'wf089' => self::$pics['d082'], // _Ch (gv)
		'wf08a' => self::$pics['d083'], // Nu (gv)
		'wf08b' => self::$pics['d081'], // Xy[h (gv)
		'wf08c' => self::$pics['d237'], // Nbv
		'wf08d' => self::$pics['d004'], // Ⴞ
		'wf08e' => self::$pics['d073'], // o[Xf[P[L
		'wf08f' => self::$pics['d258'], // ь
		'wf090' => self::$pics['d072'], // v[g
		'wf091' => self::$pics['d168'], // h
		'wf092' => self::$pics['d209'], //  (E)
		'wf093' => self::$pics['d209'], // hA
		'wf094' => self::$pics['d170'], // ₶
		'wf095' => self::$pics['d075'], // gѓdb
		'wf096' => '',                // 
		'wf097' => self::$pics['d065'], // `Pbg
		'wf098' => self::$pics['d139'], // n[g2
		'wf099' => self::$pics['d151'], // d
		'wf09a' => self::$pics['d091'], // 
		'wf09b' => self::$pics['d140'], // ъ
		'wf09c' => self::$pics['d024'], // ejX
		'wf09d' => self::$pics['d058'], // fJ
		'wf09e' => self::$pics['d026'], // XL[
		'wf09f' => self::$pics['d160'], // !!
		'wf0a0' => self::$pics['d159'], // !?
		'wf0a1' => '?',                 // ?
		'wf0a2' => self::$pics['d156'], // J[u
		'wf0a3' => self::$pics['d145'], // J[u
		'wf0a4' => self::$pics['d228'], // ew OK TC
		'wf0a5' => '[͂]',          // ͂
		'wf0a6' => '' . self::$pics['d136'], // ˎ~߂n[g
		'wf0a7' => self::$pics['d155'], // Ԋ
		'wf0a8' => self::$pics['d006'], // 䕗
		'wf0a9' => self::$pics['d102'], // C
		'wf0aa' => self::$pics['d252'], // T[tB
		'wf0ab' => self::$pics['d253'], // R
		'wf0ac' => self::$pics['d253'], // xmR
		'wf0ad' => '[Lv]',        // eg (Lv)
		'wf0ae' => self::$pics['d260'], // t
		'wf0af' => self::$pics['d035'], // oX
		'wf0b0' => self::$pics['d025'], // TbJ[
		'wf0b1' => '[S]',          // S҃}[N
		'wf0b2' => '',                // d
		'wf0b3' => '',                // dE
		'wf0b4' => '[dv]',            // dv
		'wf0b5' => self::$pics['d245'], // 18
		'wf0b6' => self::$pics['d244'], // !
		'wf0b7' => self::$pics['d242'], // TCN}[N
		'wf0b8' => '[.i|]',             // Aei
		'wf0b9' => ')))',               // )))
		'wf0ba' => '~',                // ~
		'wf0bb' => self::$pics['d238'], // 쌠 (C)
		'wf0bc' => self::$pics['d243'], // o^W (R)
		'wf0bd' => '[777]',             // Xbg (777)
		'wf0be' => self::$pics['d134'], // 0 (zero)
		'wf0bf' => self::$pics['d125'], // 1 (one)
		'wf0c0' => self::$pics['d126'], // 2 (two)
		'wf0c1' => self::$pics['d127'], // 3 (three)
		'wf0c2' => self::$pics['d128'], // 4 (four)
		'wf0c3' => self::$pics['d129'], // 5 (five)
		'wf0c4' => self::$pics['d130'], // 6 (six)
		'wf0c5' => self::$pics['d131'], // 7 (seven)
		'wf0c6' => self::$pics['d132'], // 8 (eight)
		'wf0c7' => self::$pics['d133'], // 9 (nine)
		'wf0c8' => self::$pics['d009'], // r
		'wf0c9' => self::$pics['d010'], // 
		'wf0ca' => self::$pics['d011'], // oq
		'wf0cb' => self::$pics['d012'], // I
		'wf0cc' => self::$pics['d013'], // q
		'wf0cd' => self::$pics['d014'], // 
		'wf0ce' => self::$pics['d015'], // V
		'wf0cf' => self::$pics['d016'], // 嶍
		'wf0d0' => '[֌]',          // ֌
		'wf0d1' => self::$pics['d017'], // ˎ
		'wf0d2' => self::$pics['d018'], // Rr
		'wf0d3' => self::$pics['d019'], // r
		'wf0d4' => self::$pics['d020'], // 
		'wf0d5' => self::$pics['d170'], // n
		'wf0d6' => self::$pics['d054'], // }Nhih
		'wf0d7' => self::$pics['d054'], // Xo[K[
		'wf0d8' => '@',                // [gp]
		'wf0d9' => self::$pics['d054'], // beA
		'wf0da' => '@',                // [gp]
		'wf0db' => self::$pics['d051'], // hg[R[q[
		'wf0dc' => '@',                // [gp]
		'wf0dd' => '@',                // [gp]
		'wf0de' => '@',                // [gp]
		'wf0df' => '@',                // [gp]
		'wf0e0' => self::$pics['d050'], // o[~
		'wf0e1' => '@',                // [gp]
		'wf0e2' => '@',                // [gp]
		'wf0e3' => self::$pics['d050'], // тhL[
		'wf0e4' => '@',                // [gp]
		'wf0e5' => '@',                // [gp]
		'wf0e6' => '@',                // [gp]
		'wf0e7' => self::$pics['d045'], // [\
		'wf0e8' => '@',                // [gp]
		'wf0e9' => self::$pics['d045'], // am/pm
		'wf0ea' => '@',                // [gp]
		'wf0eb' => '@',                // [gp]
		'wf0ec' => '@',                // [gp]
		'wf0ed' => '@',                // [gp]
		'wf0ee' => '@',                // [gp]
		'wf0ef' => '@',                // [gp]
		'wf0f0' => self::$pics['d039'], // SݓX
		'wf0f1' => '@',                // [gp]
		'wf0f2' => '@',                // [gp]
		'wf0f3' => '@',                // [gp]
		'wf0f4' => '@',                // [gp]
		'wf0f5' => '@',                // [gp]
		'wf0f6' => '@',                // [gp]
		'wf0f7' => '@',                // [gp]
		'wf0f8' => '@',                // [gp]
		'wf0f9' => '@',                // [gp]
		'wf0fa' => '@',                // [gp]
		'wf0fb' => '@',                // [gp]
		'wf0fc' => self::$pics['d100'], // n`
		'wf140' => self::$pics['d170'], // C
		'wf141' => '@',                // [gp]
		'wf142' => '@',                // [gp]
		'wf143' => '@',                // [gp]
		'wf144' => '@',                // [gp]
		'wf145' => '@',                // [gp]
		'wf146' => '@',                // [gp]
		'wf147' => '@',                // [gp]
		'wf148' => self::$pics['d042'], // UFJ Bank
		'wf149' => '@',                // [gp]
		'wf14a' => '@',                // [gp]
		'wf14b' => '@',                // [gp]
		'wf14c' => '@',                // [gp]
		'wf14d' => self::$pics['d209'], //  ()
		'wf14e' => '@',                // [gp]
		'wf14f' => '@',                // [gp]
		'wf150' => self::$pics['d234'], // 
		'wf151' => '@',                // [gp]
		'wf152' => '@',                // [gp]
		'wf153' => '@',                // [gp]
		'wf154' => '@',                // [gp]
		'wf155' => '@',                // [gp]
		'wf156' => '@',                // [gp]
		'wf157' => '@',                // [gp]
		'wf158' => '@',                // [gp]
		'wf159' => '@',                // [gp]
		'wf15a' => '@',                // [gp]
		'wf15b' => '@',                // [gp]
		'wf15c' => '@',                // [gp]
		'wf15d' => '@',                // [gp]
		'wf15e' => '@',                // [gp]
		'wf15f' => '@',                // [gp]
	));
	$buffer = preg_replace(
		'!<img localsrc="([^"]+)"( alt="([^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*)")? ?/?>!e', 
		'isset($trans["$1"]) ? $trans["$1"] : ("$3" ? "$3" : "")', 
		$buffer);
	$entities = array(
		'&spades;' => self::$pics['d081'],
		'&#9824;'  => self::$pics['d081'],
		'&#x2660;' => self::$pics['d081'],
		'&clubs;'  => self::$pics['d083'],
		'&#9827;'  => self::$pics['d083'],
		'&#x2663;' => self::$pics['d083'],
		'&hearts;' => self::$pics['d080'],
		'&#9829;'  => self::$pics['d080'],
		'&#x2665;' => self::$pics['d080'],
		'&#9825;'  => self::$pics['d136'], // WHITE HEART
		'&#x2661;' => self::$pics['d136'], // WHITE HEART
		'&diams;'  => self::$pics['d082'],
		'&#9830;'  => self::$pics['d082'],
		'&#x2666;' => self::$pics['d082'],
		'&#12336;' => self::$pics['d165'], // WAVY DASH
		'&#x3030;' => self::$pics['d165'], // WAVY DASH
	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);
	return parent::convert_pict($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<img src="([^>]*?)\.png"!', '<img src="\\1.gif"', $buffer);
	$buffer = preg_replace('!<a href="([^>]*?)\.png"!', '<a href="\\1.gif"', $buffer);
	$buffer = preg_replace('!<(b|i|u|em|strong)>(.*?)</\\1>!', '$2', $buffer);
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function pickup_pics($buffer) {
	$pics = array_flip(self::$pics);
	if (! $pics) {
		return $buffer;
	}
	mb_regex_encoding($this->charset);
	$replaced = mb_ereg_replace(
		"([\xf8\x40-\xf8\x5b]|[\xf8\x5d-\xf8\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc])", 
		'isset($pics["\1"]) ? 
		"<img localsrc=\"" . $pics["\1"] . "\" />" : 
		"<img localsrc=\"d\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf8\x5c", '<img localsrc="d" alt="[0xf85c]" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="' . $pics["\xf9\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_mova class
   ================================================== */

class Ktai_Service_imode_mova extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_mova');
	$this->type       = 'mova';
	$this->flat_rate  = FALSE;
	preg_match('!1\.0/([-_.a-zA-Z0-9]+)(/c(\d+)(/\w+)*?(/ser(\w+))?)?!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[6];
	$this->sub_ID     = @$_SERVER['HTTP_X_DCMGUID'];
	$this->page_size  = 5000;
	$this->cache_size = ($specs[3] > 0) ? intval($specs[3]) * 1024 : 5120;
	$this->preamble   = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	$buffer = preg_replace('!\s*</(li|dt|dd|option)>\s*!', '', $buffer);
	$buffer = preg_replace('! ?/ ?>!', '>', $buffer);
	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>!', '<$1>', $buffer); //"
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_FOMA class
   ================================================== */

class Ktai_Service_imode_FOMA extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_foma');
	$this->type       = 'FOMA';
	$this->flat_rate  = TRUE;
	preg_match('!2\.\d ([-_.a-zA-Z0-9]+)\(c(\d+)(;\w+)*?(;ser(\w+);icc(\w+))?\)!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[5];
	$this->usim_ID    = @$specs[6];
	$this->sub_ID     = @$_SERVER['HTTP_X_DCMGUID'];
	$this->page_size  = 10000;
	$this->cache_size = ($specs[2] > 0) ? intval($specs[2]) * 1024 : 102400;
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/1.0) 1.0//EN" "i-xhtml_4ja_10.dtd">';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	if ($this->mime_type == 'application/xhtml+xml') {
		$buffer = preg_replace('|<blink>(.*?)</blink>|', '<span style="text-decoration:blink;">$1</span>', $buffer);
	}
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}
?>