<?php
/*
Plugin Name: wp-tmkm-amazon
Plugin URI: http://tomokame.moo.jp/
Description: ASIN を指定して Amazon から個別商品の情報を取出します。BOOKS, DVD, CD は詳細情報を取り出せます。
Author: ともかめ
Version: 1.0ja
Author URI: http://tomokame.moo.jp/
Special Thanks: Keith Devens.com (http://keithdevens.com/software/phpxml)
Special Thanks: websitepublisher.net (http://www.websitepublisher.net/article/aws-php/)
Special Thanks: hiromasa.zone :o) (http://hiromasa.zone.ne.jp/)
Special Thanks: PEAR :: Package :: Cache_Lite (http://pear.php.net/package/Cache_Lite)
*/

/********** Notes
 # ECS4.0 に対応しています。
 # PHP4.x で動作します。ただし Keith Devens.com の PHP XML Library が必要（ 同梱しています ）。
 # [tmkm-amazon]ASIN[/tmkm-amazon] または <?php tmkm_amazon_view('ASIN'); ?> という記述で動作します。
 # LGPL で提供されている Lite.php および Open Source License で提供されている xml.php を同梱しています。
 # 記事およびページ投稿／編集画面での Amazon 検索が可能です。
**********/

/********** Usage
 # 1. ダウンロードした zip ファイルを解凍します。
 # 2. wp-tmkm-amazon-function.php の 23 行目 tomokametei-22 を、ご自身のアフィリエイト ID に書き換えます。
 # 3. 同梱の tmkm-amazon.css の記述を、お使いのテーマの CSS ファイルに追記します。
 # 4. wp-tmkm-amazon フォルダを wp-content/plugins フォルダに転送します。
 # 5. 管理画面から wp-tmkm-amazon を有効化します。
 # 6. 各テーマの php ファイル、もしくは記事本文中に以下を記載します。
 ## PHP 関数として呼び出す場合	...	<?php tmkm_amazon_view('ASIN'); ?>　：テーマファイルに記述
 ## 記事本文中にコードを書く場合	...	[tmkm-amazon]ASIN[/tmkm-amazon]
 
 ## 記事本文中で PHP コードを実行できるプラグインを導入していれば、PHP 関数として呼び出すこともできます。
 ## 書籍の場合、ASIN に 10 桁および 13 桁の ISBN を使用できます。
 ## 同梱の amazon_noimg.png と amazon_noimg_small.png を差し替えれば、商品画像がないときの代替画像を好きなものにできます。
**********/

include_once('wp-tmkm-amazon-function.php');

$wpTmkmAmazonView = & new WpTmkmAmazonView();
$wpTmkmAmazonList = & new WpTmkmAmazonList();
$wpTmkmAmazonFind = & new WpTmkmAmazonFind();

add_filter('the_content',		array(&$wpTmkmAmazonView, '_replacestrings'));
add_filter('edit_form_advanced',	array(&$wpTmkmAmazonFind, 'InsertSearchForm'));
add_filter('edit_page_form',		array(&$wpTmkmAmazonFind, 'InsertSearchForm'));


class WpTmkmAmazonView {

	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */

	function WpTmkmAmazonView() {
		$this->makedetailview = & new MakeAmazonHtml();
	}

	/**
	 * 記事本文中のコードを個別商品表示 HTML に置き換える
	 * 
	 * @param $content
	 * @return $transformedstring
	 */
	function _replacestrings($content) { // 記事本文中の呼び出しコードを変換

		global $post;

		$poststring = '/\[tmkm-amazon\]([a-zA-Z0-9,]+)\[\/tmkm-amazon\]/';
		$transformedstring = $content;
		if( preg_match_all($poststring, $content, $regs1) ) {

			for ($i=0; $i<count($regs1[0]); $i++) {
				$SearchString = $regs1[1][$i];

				$display = $this->makedetailview->format_amazon( $SearchString, 'detail' );

				if( ereg( $SearchString, $regs1[0][$i], $str ) ) { // ASINコードの置換
					$transformedstring = str_replace($regs1[0][$i], $display, $transformedstring);
				}
			}
		}

		return $transformedstring;

	}


	/**
	 * PHP 関数として Amazon の個別商品 HTML を呼び出す
	 * 
	 * @param $SearchString ( ASIN )
	 * @param $type ( book / dvd / cd )
	 * @return echo $display ( HTML )
	 */
	function tmkm_amazon_view($SearchString) { // PHP テ−マファイル中に記述する関数
		$display = $this->makedetailview->format_amazon( $SearchString, 'detail' );
		echo $display;
	}


}


class WpTmkmAmazonList {

	var $sql;
	var $ordersql;

	function WpTmkmAmazonList() {

		$this->makedetailview = & new MakeAmazonHtml();
		$this->sql = '';
		$this->ordersql = '';

	}

	function tmkm_amazon_list( $orderby = 'post_id', $order = 'asc' ) {
	
	    global $wpdb;

		switch( $orderby ) {
			case post_id: $this->ordersql = "$wpdb->posts.ID " . $order; break;
			case post_title: $this->ordersql = "$wpdb->posts.post_title " . $order; break;
			case post_date: $this->ordersql = "$wpdb->posts.post_date " . $order; break;
			case modified_date: $this->ordersql = "$wpdb->posts.post_modified " . $order; break;
		}

	    $this->sql =
			"SELECT " .
				"ID, post_title, " .
				"DATE_FORMAT(post_modified, '%Y/%m/%d') as mdate, " .
				"meta_key, meta_value " .
			"FROM " .
				"$wpdb->posts, $wpdb->postmeta " .
			"WHERE " .
				"$wpdb->posts.ID = $wpdb->postmeta.post_id AND " .
				"$wpdb->posts.post_date <= NOW() AND " .
				"$wpdb->posts.post_status = 'publish' AND " .
				"$wpdb->postmeta.meta_key = 'tmkm-amazon' " .
			"ORDER BY " .
				$this->ordersql;

	    $PostRetainAsin = $wpdb->get_results($this->sql);
	    if( $PostRetainAsin ) {
	    	print '<div id="amazonlist">';
	    	foreach( $PostRetainAsin as $asinlist ) {
	    		$asins = explode(',',$asinlist->meta_value);
	    		foreach( $asins as $asin ) {
	    			$permalink = get_permalink($asinlist->ID);
	    			$display = $this->makedetailview->format_amazon( $asin, 'list' );

	    			$heredoc  = '<dd>';
	    			$heredoc .= $display;
	    			$heredoc .= '<p>このブログの記事：<a href="' . $permalink . '">' . $asinlist->post_title . '</a> ( ' . $asinlist->mdate . ' )</p>';
	    			$heredoc .= '</dd><div style="clear: both"></div>';
	    			echo $heredoc;
	    		}
	    	}
	    	print '</div>';
	    	echo '<p style="clear:both"></p>';
	    }
	}

}

class MakeAmazonHtml {
	var $plugin_path;
	var $mediumimgfile;
	var $smallimgfile;

	function MakeAmazonHtml() {

		$this->amazonparse = & new GetAmazonXmlParse();
		$this->generalfunclib = & new generalFuncLibrary();

	}

	/**
	 * Amazon 商品の HTML ソースを生成
	 * @param $SearchString ( ASIN )
	 * @param $mediatype ( book / dvd / cd )
	 * @return $output ( HTML )
	 */
	function format_amazon( $SearchString, $formattype ) {

   		$this->plugin_path  = get_option('siteurl');
        $this->plugin_path .= '/wp-content/plugins/wp-tmkm-amazon/';
        $this->mediumimgfile = 'amazon_noimg.png';
        $this->smallimgfile = 'amazon_noimg_small.png';

		$output = '';
		if( strlen( $SearchString ) == 13 ){
			$SearchString = $this->generalfunclib->calc_chkdgt_isbn10( substr( $SearchString, 3, 9 ) );
		}

		$AmazonXml = $this->amazonparse->getamazonxml( $SearchString, 'single', '', 'Large' ); // --- Call Amazon XML function ---

		// --- Get results of the Amazon function ---
		if( false === $AmazonXml ){  // Amazon function was returned false, so AWS is down

			echo '<p>アマゾンのサーバでエラーが起こっているかもしれません。一度ページを再読み込みしてみてください。</p>';

		}else{ // Amazon function returned XML data

			$status = $AmazonXml["ItemLookupResponse"]["Items"]["Request"];

			if( $status["IsValid"] == 'False' ){ // Request is invalid

				echo '<p>与えられたリクエストが正しくありません</p>';

			}else{ // results were found, so display the products
	
		// --- Display the product data returned from the XML ---
				$item = $AmazonXml["ItemLookupResponse"]["Items"]["Item"];

				$mediumimage = $this->amazonparse->get_goods_image($item,'medium');
				if( $mediumimage == '' ) { $mediumimage = $this->plugin_path . $this->mediumimgfile; }
				$smallimage = $this->amazonparse->get_goods_image($item,'small');
				if( $smallimage == '' ) { $smallimage = $this->plugin_path . $this->smallimgfile; }

				$url = $this->amazonparse->get_amazon_text($item,'url');
				$Title = $this->amazonparse->get_amazon_text($item,'title');
				$Manufacturer = $this->amazonparse->get_amazon_text($item,'manufacturer');
				$Binding = $this->amazonparse->get_amazon_text($item,'binding');
				$EANcode = $this->amazonparse->get_amazon_text($item,'eancode');

				$Price = $this->amazonparse->get_amazon_text($item,'price');
				$ASIN = $this->amazonparse->get_amazon_text($item,'asincode');
				$ReleaseDate = $this->amazonparse->get_amazon_text($item,'releasedate');

				$ProductGroup = $this->amazonparse->get_amazon_text($item,'productgroup');


				if( $formattype == 'detail' ) {
					if( $ProductGroup == 'Book' ){
	
						$Role = $this->amazonparse->get_amazon_text($item,'role');
						$Author = $this->amazonparse->get_amazon_text($item,'author');
						$ISBN10 = $this->amazonparse->get_amazon_text($item,'isbn10');
						$PublicationDate = $this->amazonparse->get_amazon_text($item,'publicationdate');
	
						$output = '<a href="'.$url.'"><img src="' . $mediumimage . '" border="0" alt="" class="icon_left" /></a></p>';
						$output .= '<p><a href="'.$url.'">' . $Title . "</a>";
						if( $Author != "" ) {
							$output .= "<br /><em>著者／訳者：</em>";
							if( count($Author) == 1 ) { $output .= $Author; 
							} else { foreach($Author as $auth){ $output .= $auth.' '; } } }
						$output .= "<br /><em>出版社：</em>$Manufacturer( $PublicationDate )";
						$output .= "<br /><em>定価：</em>$Price";
						$output .= "<br />$Binding";
						$output .= "<br />ISBN-10 : $ISBN10";
						$output .= "<br />ISBN-13 : $EANcode";
	
					} elseif( $ProductGroup == 'DVD' ) {
	
						$RunningTime = $this->amazonparse->get_amazon_text($item,'runningtime');
						$numofdisc = $this->amazonparse->get_amazon_text($item,'numofdisc');
	
						$output = '<a href="'.$url.'"><img src="' . $mediumimage . '" border="0" alt="" class="icon_left" /></a></p>';
						$output .= '<p><a href="'.$url.'">' . $Title . "</a>";
						$output .= "<br /><em>販売元：</em>$Manufacturer( $ReleaseDate )";
						$output .= "<br /><em>定価：</em>$Price";
						$output .= "<br /><em>時間：</em>$RunningTime 分";
						$output .= "<br />$numofdisc" . " 枚組 ( " . $Binding . " )";
						$output .= "<br />ASIN : $ASIN";
						$output .= "<br />JAN コード : $EANcode";
	
					} elseif( $ProductGroup == 'Music' ) {
	
						$Format = $this->amazonparse->get_amazon_text($item,'format');
						$Artist = $this->amazonparse->get_amazon_text($item,'artist');
	
						$output = '<a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="" class="icon_left" /></a></p>';
						$output .= '<p><a href="'.$url.'">' . $Title . ' / ' . $Artist . "</a> / $Format $Binding ( $ProductGroup )";
						$output .= "<br />$Manufacturer";
						$output .= "<br /><em>定価：</em>$Price ( $ReleaseDate )";
						$output .= "<br />ASIN : $ASIN ( JAN コード : $EANcode )";
	
					} else {
						$output = '<a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="' . $Title . '" class="icon_left" /></a>';
						$output .= '<p><a href="'.$url.'">' . $Title . "</a>";
						if( $Price != '' ) { $output .= "<br /><em>定価：</em>$Price"; }
						if( $ReleaseDate != '' ) { $output .= "<br /><em>発売日：</em>$ReleaseDate"; }
						$output .= "<br />ASIN : $ASIN";
						if( $EANcode != '' ) { $output .= "<br />JAN コード : $EANcode"; }
					}
					$clearparts = "</p>" . '<p style="clear:both"></p>';
					$output .= $clearparts;

				} elseif( $formattype == 'list' ) {
					$output = '<a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="' . $Title . '" class="icon_left" /></a></p>';
					$output .= '<p><a href="'.$url.'">' . $Title . "</a>";
				}

				return $output;
				
			}
		}
	}

}

class WpTmkmAmazonFind {

	var $searchphp_path;

	function InsertSearchForm() {

		global $wpdb;

		$this->searchphp_path  = get_option('siteurl');
        $this->searchphp_path .= '/wp-content/plugins/wp-tmkm-amazon/wp-tmkm-amazon-search.php';

		?>
		<div id="wptmkmamazon" class="postbox if-js-closed">
		<h3>wp-tmkm-amazon</h3>
		<div class="inside">
			<iframe id="uploading" frameborder="0" src="<?php echo $this->searchphp_path; ?>">IFRAME による表示がサポートされている環境が必要です。</iframe>
		</div>
		</div>
		<?php 

	}
}

if(!function_exists('tmkm_amazon_view')) {
	function tmkm_amazon_view($Searchstring) {
		global $wpTmkmAmazonView;
		$wpTmkmAmazonView->tmkm_amazon_view($Searchstring);
		
	}
}

if(!function_exists('tmkm_amazon_list')) {
	function tmkm_amazon_list($orderby,$order) {
		global $wpTmkmAmazonList;
		$wpTmkmAmazonList->tmkm_amazon_List($orderby,$order);
		
	}
}
?>